/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.components.controllers.mock;

import com.suncode.plugin.components.controllers.base.BaseRestController;
import com.suncode.plugin.components.controllers.base.InvalidInputException;
import com.suncode.plugin.dashboard.web.support.RestResult;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/mock/status"})
public class MockStatusController
extends BaseRestController {
    @GetMapping
    public RestResult getRandomStatus(@RequestParam String category, HttpServletResponse response) {
        StatusCategory statusCategory;
        try {
            statusCategory = StatusCategory.valueOf(category.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            String supportedCategory = Arrays.stream(StatusCategory.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.joining(", "));
            throw new InvalidInputException("Supported categories are '" + supportedCategory + "'.");
        }
        HttpStatus httpStatus = statusCategory.getStatus();
        response.setStatus(httpStatus.value());
        return new RestResult(true, httpStatus.getReasonPhrase());
    }

    public static enum StatusCategory {
        SUCCESSFUL(HttpStatus.OK),
        CLIENT_ERROR(HttpStatus.BAD_REQUEST),
        SERVER_ERROR(HttpStatus.INTERNAL_SERVER_ERROR);

        private final HttpStatus status;

        public HttpStatus getStatus() {
            return this.status;
        }

        private StatusCategory(HttpStatus status) {
            this.status = status;
        }
    }
}

