/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.components.controllers.mock;

import com.suncode.plugin.components.controllers.base.InvalidInputException;
import com.suncode.plugin.dashboard.web.support.RestResult;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/mock/time"})
public class MockCurrentTimeController {
    private static final String DEFAULT_FORMAT = "yyyy-MM-dd HH:mm:ss";

    @GetMapping(value={"/current"})
    public RestResult getCurrentTime() {
        return this.formatDateTime(LocalDateTime.now(), DEFAULT_FORMAT);
    }

    @PostMapping(value={"/formated"})
    public RestResult getFormatedTime(@RequestBody FormatRequest request) {
        if (StringUtils.isBlank((CharSequence)request.format)) {
            throw new InvalidInputException("Date format parameter cannot be empty or blank");
        }
        return this.formatDateTime(LocalDateTime.now(), request.format);
    }

    private RestResult formatDateTime(LocalDateTime dateTime, String format) {
        try {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
            String formattedTime = dateTime.format(formatter);
            return new RestResult(true, formattedTime);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidInputException("Invalid date format pattern: " + format);
        }
    }

    public record FormatRequest(String format) {
    }
}

