/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.components.controllers.mock;

import com.suncode.plugin.dashboard.web.support.RestResult;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Base64;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/mock/auth"})
public class MockAuthController {
    private static final String BASIC_AUTH_CREDENTIALS = Base64.getEncoder().encodeToString("clientApp:secret123".getBytes());
    private static final String BEARER_TOKEN = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.mocked.payload.signature";
    private static final String API_KEY = "3fa85f64-5717-4562-b3fc-2c963f66afa6";
    private static final String COOKIE_SESSION = "eyJzZXNzaW9uSWQiOiJhYmMxMjM0NSIsInVzZXIiOiJ1c2VyQHRlc3QuY29tIn0.mockedSig";

    @PostMapping(value={"/basic"})
    public RestResult authenticateWithBasic(@RequestHeader(value="Authorization", required=false) String authorization) {
        if (authorization == null || !authorization.startsWith("Basic ")) {
            throw new SecurityException("Missing or invalid Authorization header for Basic Auth");
        }
        String credentials = authorization.substring("Basic ".length()).trim();
        if (!credentials.equals(BASIC_AUTH_CREDENTIALS)) {
            throw new SecurityException("Invalid Basic credentials");
        }
        return new RestResult(true, "Basic Auth");
    }

    @PostMapping(value={"/bearer"})
    public RestResult authenticateWithBearer(@RequestHeader(value="Authorization", required=false) String authorization) {
        if (authorization == null || !authorization.startsWith("Bearer ")) {
            throw new SecurityException("Missing or invalid Authorization header for Bearer Token");
        }
        String token = authorization.substring("Bearer ".length()).trim();
        if (!token.equals(BEARER_TOKEN)) {
            throw new SecurityException("Invalid Bearer token");
        }
        return new RestResult(true, "Bearer Token");
    }

    @PostMapping(value={"/apikey"})
    public RestResult authenticateWithApiKey(@RequestHeader(value="X-API-KEY", required=false) String apiKey) {
        if (apiKey == null || apiKey.isBlank()) {
            throw new SecurityException("Missing X-API-KEY header");
        }
        if (!apiKey.equals(API_KEY)) {
            throw new SecurityException("Invalid API Key");
        }
        return new RestResult(true, "API Key");
    }

    @GetMapping(value={"/cookie"})
    public RestResult getMockedCookie(HttpServletResponse response) {
        response.addCookie(new Cookie("X-SESSION", COOKIE_SESSION));
        return new RestResult(true, "Cookie set");
    }

    @PostMapping(value={"/cookie"})
    public RestResult authenticateWithCookie(@CookieValue(value="X-SESSION", required=false) String sessionCookie) {
        if (sessionCookie == null || sessionCookie.isBlank()) {
            throw new SecurityException("Missing X-SESSION cookie");
        }
        if (!sessionCookie.equals(COOKIE_SESSION)) {
            throw new SecurityException("Invalid session token");
        }
        return new RestResult(true, "Cookie Auth");
    }
}

