/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.components.controllers.base;

import com.suncode.plugin.components.controllers.base.InvalidInputException;
import com.suncode.plugin.dashboard.web.support.RestResult;
import com.suncode.plugin.utils.authorization.AuthorizationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public abstract class BaseRestController {
    private static final Logger log = LoggerFactory.getLogger(BaseRestController.class);

    protected RestResult executeSecured(SecuredOperation operation) {
        AuthorizationUtil.assertAdministrationRights();
        return operation.execute();
    }

    protected <T> ResponseEntity<T> executeSecuredWithResponse(SecuredResponseOperation<T> operation) {
        AuthorizationUtil.assertAdministrationRights();
        return operation.execute();
    }

    @ExceptionHandler(value={SecurityException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public RestResult handleSecurityException(SecurityException e) {
        log.warn("Access denied: {}", (Object)e.getMessage());
        return new RestResult(false, "Access denied: " + e.getMessage());
    }

    @ExceptionHandler(value={InvalidInputException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public RestResult handleInvalidInputException(InvalidInputException e) {
        log.warn("Invalid input: {}", (Object)e.getMessage());
        return new RestResult(false, e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public RestResult handleException(Exception e) {
        log.error("Unexpected error occurred", (Throwable)e);
        return new RestResult(false, "Internal server error: " + e.getMessage());
    }

    @FunctionalInterface
    protected static interface SecuredOperation {
        public RestResult execute();
    }

    @FunctionalInterface
    protected static interface SecuredResponseOperation<T> {
        public ResponseEntity<T> execute();
    }
}

