/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.components.controllers;

import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.components.controllers.base.BaseRestController;
import com.suncode.plugin.dashboard.web.support.RestResult;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentFinder;
import com.suncode.pwfl.archive.WfDocument;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/documents"})
public class DocumentDeprecationController
extends BaseRestController {
    private static final Logger log = LoggerFactory.getLogger(DocumentDeprecationController.class);
    private final DocumentClassActionService documentClassActionService;
    private final DocumentFinder documentFinder;

    @PutMapping(value={"/deprecation"})
    public RestResult checkDeprecation() {
        return this.executeSecured(() -> {
            List expiredDocuments = this.documentFinder.findExpiredDocuments();
            if (!expiredDocuments.isEmpty()) {
                expiredDocuments.forEach(this::processExpiredDocument);
            }
            return new RestResult(true);
        });
    }

    private void processExpiredDocument(WfDocument document) {
        log.info("Processing expired document [id={}, filename={}]", (Object)document.getId(), (Object)document.getFile().getFileName());
        this.documentClassActionService.executeArchiveActions(document, DocumentEventTypes.DOCUMENT_EXPIRED);
    }

    @Autowired
    public DocumentDeprecationController(DocumentClassActionService documentClassActionService, DocumentFinder documentFinder) {
        this.documentClassActionService = documentClassActionService;
        this.documentFinder = documentFinder;
    }
}

