/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.components.controllers;

import com.suncode.plugin.components.controllers.base.BaseRestController;
import com.suncode.plugin.services.datasource.AuthorizationExportService;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/authorization"})
public class AuthorizationExportController
extends BaseRestController {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationExportController.class);
    private final AuthorizationExportService authorizationExportService;

    @GetMapping(value={"/export"})
    public ResponseEntity<ByteArrayResource> exportAuthorizations() {
        return this.executeSecuredWithResponse(() -> {
            try {
                String jsonContent = this.authorizationExportService.exportAuthorizations();
                ByteArrayResource resource = new ByteArrayResource(jsonContent.getBytes(StandardCharsets.UTF_8));
                return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=dsRestExport.json"})).contentType(MediaType.APPLICATION_JSON).contentLength(resource.contentLength()).body((Object)resource);
            }
            catch (Exception e) {
                log.error("Error during authorization export", (Throwable)e);
                throw new RuntimeException("Failed to export authorizations: " + e.getMessage(), e);
            }
        });
    }

    @Autowired
    public AuthorizationExportController(AuthorizationExportService authorizationExportService) {
        this.authorizationExportService = authorizationExportService;
    }
}

