(function (Ext) {
  var messages = Suncode.context('pzmodule').messages;

  Ext.define('Suncode.pzmodule.controller.menu.RecordTableMenuController', {
    extend: 'Ext.app.Controller',
    init: function () {
      this.control({
        'menuitem[itemId=selectGroupMenuItem]': {
          click: this.selectGroup
        },
        'menuitem[itemId=deselectGroupMenuItem]': {
          click: this.deselectGroup
        },
        'menuitem[itemId=showSubGroupsFilterMenuItem]': {
          click: this.showSubGroupsFilter
        },
        'menuitem[itemId=saveSettingsItem]': {
          click: this.showSaveSettingsWindow
        },
        'menuitem[itemId=displaySettingsItem]': {
          click: this.showDisplaySettingsWindow
        }
      });
    },
    selectGroup: function (item, e, eOpts) {
      this.toggleGroup(item, this.selectGroupCallback);
    },
    selectGroupCallback: function (operation) {
      var table = this;

      if (operation.wasSuccessful()) {
        var records = operation.getRecords();
        table.selectRecords(records);
      }
    },
    deselectGroup: function (item, e, eOpts) {
      this.toggleGroup(item, this.deselectGroupCallback);
    },
    deselectGroupCallback: function (operation) {
      var table = this;

      if (operation.wasSuccessful()) {
        var records = operation.getRecords();
        table.deselectRecords(records);
      }
    },
    toggleGroup: function (item, callback) {
      var table = item.table;
      var getGroups = table.buildGetGroups(item.group);
      var store = table.getStore();
      var options = {
        action: 'read',
        start: 0,
        limit: 0,
        params: {
          getGroups: Ext.JSON.encode(getGroups),
          preventSort: true,
          preventCount: true,
          preventAmount: true
        }
      };
      var filtersFeature = table.getView().getFeature('filters');
      if (!Ext.isEmpty(filtersFeature)) {
        filtersFeature.onBeforeLoad(store, options);
      }

      var operation = new Ext.data.Operation(options);
      var proxy = store.getProxy();
      proxy.read(operation, callback, table);
    },
    showSubGroupsFilter: function (item, e, eOpts) {
      var event = item.event;
      var table = item.table;
      var filter = Ext.create('Suncode.pzmodule.view.filter.SubGroupsFilter', {
        table: item.table,
        groupId: item.group,
        groupingField: table.getNextGroupingField(item.group)
      });
      var menu = Ext.create('Ext.menu.Menu', {
        plain: true,
        items: [filter]
      });
      menu.showAt([event.getPageX(), event.getPageY()]);
    },
    showSaveSettingsWindow: function (item, e, eOpts) {
      this.showSettingsWindow(item,
          'Suncode.pzmodule.view.window.SaveSettingsWindow');
    },
    showDisplaySettingsWindow: function (item, e, eOpts) {
      this.showSettingsWindow(item,
          'Suncode.pzmodule.view.window.SettingsWindow');
    },
    showSettingsWindow: function (item, componentName) {
      var table = item.table
      var win = Ext.create(componentName, {
        table: table
      }).show();
      table.showWindowInCenter(win);
    }
  });
}(this.Ext4));