/**
 * Run PZ module.
 */
PW.EventActions.register( 'run-pz-module', function( context, configurationId, extraParamsNames, extraParamsValues, saveForm ) {
  var href = [ document.location.protocol, '//', document.location.host, document.location.pathname ].join( '' );
  var lastSymbol = href.lastIndexOf( '/' );

  if ( lastSymbol != 0 && lastSymbol != -1 ) {
    href = href.substring( 0, lastSymbol );
  }

  href += '/plugin/com.suncode.plugin-pzmodule/?configurationId=';
  href += configurationId;
  href += '&processId=';
  href += processId;
  href += '&activityId=';
  href += activityId;

  if ( !Ext.isEmpty( extraParamsNames ) && !Ext.isEmpty( extraParamsValues ) ) {
    Ext.each( extraParamsNames, function( name, index, names ) {
      var value = extraParamsValues[index];

      if ( Ext.isDefined( value ) ) {
        if ( !Ext.isEmpty( name ) ) {
          href += '&';
          href += name;
          href += '=';
          href += value;
        }
      } else {
        return false;
      }
    } );
  }

  if ( saveForm ) {
    FormService.save( {
      scope: this,
      success: function () {
        window.open( href, '_self' );
      },
      failure: function() {
        MessageService.showFailure();
      }
    } )
  } else {
    window.open( href, '_self' );
  }
} );