/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.web.support.dto.configuration.supplier;

import com.suncode.plugin.pzmodule.api.dto.configuration.ColumnDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.EditorDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.FilterInitDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.FiltersInitDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.GrouperDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.GroupingConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.NumberEditorDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.PartialAttachmentConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.PrimaryKeyDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SearchLocationDto;
import com.suncode.plugin.pzmodule.api.dto.settings.GrouperSettingsDto;
import com.suncode.plugin.pzmodule.api.dto.settings.SettingsDto;
import com.suncode.plugin.pzmodule.api.enumeration.ColumnType;
import com.suncode.plugin.pzmodule.api.enumeration.FieldType;
import com.suncode.plugin.pzmodule.api.enumeration.RecordLocation;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.supplier.ConfigurationDtoSupplier;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.supplier.FilterInitSupplier;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.supplier.GrouperDtoSupplier;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationDtoSupplierImpl
implements ConfigurationDtoSupplier {
    @Autowired
    private GrouperDtoSupplier grouperDtoSupplier;
    @Autowired
    private FilterInitSupplier filterInitSupplier;

    @Override
    public ConfigurationDto supply(ConfigurationDto dto) {
        this.supplyPrimaryKey(dto);
        this.supplyColumns(dto);
        return dto;
    }

    private void supplyPrimaryKey(ConfigurationDto dto) {
        SearchLocationDto locationDto = dto.getSearch().getLocation();
        switch (RecordLocation.getByName(locationDto.getType())) {
            case DOCUMENT_CLASS: {
                PrimaryKeyDto primaryKeyDto = dto.getSearch().getLocation().getPrimaryKey();
                primaryKeyDto.setName("fileid");
                primaryKeyDto.setType("int");
                break;
            }
        }
    }

    private void supplyColumns(ConfigurationDto dto) {
        ColumnDto primaryKeyColumnDto = this.buildPrimaryKeyColumn(dto.getSearch().getLocation().getPrimaryKey());
        if (!dto.getNotAttachedColumns().contains(primaryKeyColumnDto)) {
            dto.getNotAttachedColumns().add(primaryKeyColumnDto);
        }
        if (!dto.getAttachedColumns().contains(primaryKeyColumnDto)) {
            dto.getAttachedColumns().add(primaryKeyColumnDto);
        }
        for (ColumnDto columnDto : dto.getNotAttachedColumns()) {
            if (this.shouldUnsetColumnDoable(columnDto)) {
                columnDto.setGroupable(false);
                columnDto.setSortable(false);
            }
            columnDto.setFontSize(dto.getTableFontSize());
        }
        for (ColumnDto columnDto : dto.getAttachedColumns()) {
            if (this.shouldUnsetColumnDoable(columnDto)) {
                columnDto.setGroupable(false);
                columnDto.setSortable(false);
            }
            if (this.shouldSetColumnEditorMinValueToZero(dto, columnDto)) {
                this.setColumnEditorMinValueToZero(columnDto);
            }
            columnDto.setFontSize(dto.getTableFontSize());
            columnDto.setEditableBackgroundColor(dto.getEditableColumnBackgroundColor());
        }
    }

    private ColumnDto buildPrimaryKeyColumn(PrimaryKeyDto dto) {
        ColumnDto columnDto = new ColumnDto();
        columnDto.setDataIndex(dto.getName());
        columnDto.setHidden(true);
        columnDto.setHideable(false);
        switch (ColumnType.getByName(dto.getType())) {
            case INT: {
                columnDto.setColumnType(ColumnType.INT.getName());
                columnDto.setFieldType(FieldType.INT.getName());
                break;
            }
            case FLOAT: {
                columnDto.setColumnType(ColumnType.FLOAT.getName());
                columnDto.setFieldType(FieldType.FLOAT.getName());
                break;
            }
            case DATE: {
                columnDto.setColumnType(ColumnType.DATE.getName());
                columnDto.setFieldType(FieldType.DATE.getName());
                break;
            }
            case DATE_STRING: {
                columnDto.setColumnType(ColumnType.DATE_STRING.getName());
                columnDto.setFieldType(FieldType.DATE.getName());
                break;
            }
            default: {
                columnDto.setColumnType(ColumnType.STRING.getName());
                columnDto.setFieldType(FieldType.STRING.getName());
            }
        }
        return columnDto;
    }

    private boolean shouldUnsetColumnDoable(ColumnDto columnDto) {
        return StringUtils.isNotBlank((CharSequence)columnDto.getExpression());
    }

    private boolean shouldSetColumnEditorMinValueToZero(ConfigurationDto dto, ColumnDto columnDto) {
        PartialAttachmentConfigurationDto partialAttachmentConfiguration = dto.getPartialAttachmentConfiguration();
        return StringUtils.equals((CharSequence)columnDto.getDataIndex(), (CharSequence)partialAttachmentConfiguration.getAmountColumnId()) && BooleanUtils.isNotTrue((Boolean)partialAttachmentConfiguration.getAllowNegative());
    }

    private void setColumnEditorMinValueToZero(ColumnDto columnDto) {
        EditorDto editorDto = columnDto.getEditor();
        if (editorDto instanceof NumberEditorDto) {
            NumberEditorDto numberEditorDto = (NumberEditorDto)editorDto;
            numberEditorDto.setMinValue(0.0);
        }
    }

    @Override
    public ConfigurationDto supply(ConfigurationDto dto, SettingsDto attachedSettings, SettingsDto notAttachedSettings, Map<String, Object> activityContext, Map<String, Object> extraParameters) {
        GroupingConfigurationDto groupingConfiguration = dto.getGroupingConfiguration();
        if (attachedSettings != null) {
            this.supplyGroupers(groupingConfiguration.getAttachedGroupers(), attachedSettings.getGroupingSettings().getGroupersSettings());
        }
        if (notAttachedSettings != null) {
            this.supplyGroupers(groupingConfiguration.getNotAttachedGroupers(), notAttachedSettings.getGroupingSettings().getGroupersSettings());
        }
        this.supplyFiltersInit(dto, activityContext, extraParameters);
        return dto;
    }

    private void supplyGroupers(List<GrouperDto> groupers, List<GrouperSettingsDto> groupersSettings) {
        groupers.clear();
        groupers.addAll(this.grouperDtoSupplier.supply(groupersSettings));
    }

    private void supplyFiltersInit(ConfigurationDto dto, Map<String, Object> activityContext, Map<String, Object> extraParameters) {
        for (ColumnDto columnDto : dto.getNotAttachedColumns()) {
            this.supplyFiltersInit(columnDto.getFiltersInit(), activityContext, extraParameters);
        }
    }

    private void supplyFiltersInit(FiltersInitDto dto, Map<String, Object> activityContext, Map<String, Object> extraParameters) {
        this.supplyFilterInit(dto.getEq(), activityContext, extraParameters);
        this.supplyFilterInit(dto.getGt(), activityContext, extraParameters);
        this.supplyFilterInit(dto.getLt(), activityContext, extraParameters);
    }

    private void supplyFilterInit(FilterInitDto dto, Map<String, Object> activityContext, Map<String, Object> extraParameters) {
        this.filterInitSupplier.supply(dto, activityContext, extraParameters);
    }
}

