/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordsaver;

import com.suncode.plugin.pzmodule.api.dto.configuration.SaveActionDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SaveActionParameterDto;
import com.suncode.plugin.pzmodule.api.enumeration.SaveActionParameterType;
import com.suncode.plugin.pzmodule.api.info.SaveInfo;
import com.suncode.plugin.pzmodule.api.record.Record;
import com.suncode.plugin.pzmodule.exception.SaveActionExecutorException;
import com.suncode.plugin.pzmodule.resolver.recordprovider.DocumentClassResolver;
import com.suncode.plugin.pzmodule.resolver.recordsaver.IndexValueResolver;
import com.suncode.plugin.pzmodule.resolver.recordsaver.IndexesResolver;
import com.suncode.plugin.pzmodule.resolver.recordsaver.SaveActionParameterResolver;
import com.suncode.plugin.pzmodule.translation.Translator;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IndexesResolverImpl
implements IndexesResolver {
    private static final Logger LOG = Logger.getLogger(IndexesResolverImpl.class);
    private static final String CONFIGURATION_ERROR_MESSAGE = "pzmodule.program.configuration.error";
    @Autowired
    private SaveActionParameterResolver saveActionParameterResolver;
    @Autowired
    private DocumentClassResolver documentClassResolver;
    @Autowired
    private IndexValueResolver indexValueResolver;
    @Autowired
    private Translator translator;

    @Override
    public Map<Long, Object> resolve(SaveActionDto saveAction, SaveInfo saveInfo, List<Record> attachedRecords, Map<String, Object> activityContext, DocumentClass documentClass, SaveActionParameterType acceptedParameterType, String primaryKeyName) throws SaveActionExecutorException {
        HashMap<Long, Object> indexes = new HashMap<Long, Object>();
        List<SaveActionParameterDto> saveActionParameters = this.saveActionParameterResolver.resolve(saveAction.getParameters(), acceptedParameterType);
        if (CollectionUtils.isNotEmpty(saveActionParameters)) {
            for (SaveActionParameterDto saveActionParameter : saveActionParameters) {
                String to = saveActionParameter.getToValue();
                if (StringUtils.isBlank((CharSequence)to)) {
                    LOG.error((Object)"Brak wartosci docelowej dla parametru akcji zapisu");
                    throw new SaveActionExecutorException(this.buildConfigurationErrorMessage());
                }
                DocumentClassIndex index = this.documentClassResolver.resolveIndex(documentClass, to);
                if (index == null) {
                    LOG.error((Object)("Indeks o nazwie " + to + " nie istnieje w klasie dokumentow"));
                    throw new SaveActionExecutorException(this.buildConfigurationErrorMessage());
                }
                Object value = this.indexValueResolver.resolve(index, saveActionParameter, saveInfo, attachedRecords, activityContext, primaryKeyName);
                indexes.put(index.getId(), value);
            }
        }
        return indexes;
    }

    private String buildConfigurationErrorMessage() {
        return this.translator.translateMessage(CONFIGURATION_ERROR_MESSAGE);
    }
}

