/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordprovider;

import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SearchDto;
import com.suncode.plugin.pzmodule.api.enumeration.RecordLocation;
import com.suncode.plugin.pzmodule.api.provider.record.RecordProvider;
import com.suncode.plugin.pzmodule.resolver.externalclass.ExternalClassResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.RecordProviderResolver;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class RecordProviderResolverImpl
implements RecordProviderResolver {
    private static final Logger LOG = Logger.getLogger(RecordProviderResolverImpl.class);
    @Autowired
    @Qualifier(value="documentClassRecordProvider")
    private RecordProvider documentClassRecordProvider;
    @Autowired
    @Qualifier(value="databaseTableRecordProvider")
    private RecordProvider databaseTableRecordProvider;
    @Autowired
    private ExternalClassResolver externalClassResolver;

    @Override
    public RecordProvider resolve(ConfigurationDto configuration) {
        SearchDto search = configuration.getSearch();
        if (StringUtils.isNotBlank((CharSequence)search.getCustomClass())) {
            return this.buildCustomRecordProvider(search.getCustomClass());
        }
        switch (RecordLocation.getByName(search.getLocation().getType())) {
            case DOCUMENT_CLASS: {
                return this.documentClassRecordProvider;
            }
            case DATABASE_TABLE: {
                return this.databaseTableRecordProvider;
            }
        }
        return null;
    }

    private RecordProvider buildCustomRecordProvider(String customClass) {
        try {
            Class<?> clazz = this.externalClassResolver.resolve(customClass);
            return (RecordProvider)clazz.newInstance();
        }
        catch (Exception exception) {
            LOG.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }
}

