/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordprovider;

import com.suncode.plugin.pzmodule.api.dto.configuration.ColumnDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.GrouperDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SearchCriterionDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SorterDto;
import com.suncode.plugin.pzmodule.api.exception.RecordProviderException;
import com.suncode.plugin.pzmodule.api.translation.ColumnTranslation;
import com.suncode.plugin.pzmodule.resolver.configuration.ConfigurationResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.ColumnTranslationResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.DocumentClassResolver;
import com.suncode.plugin.pzmodule.translation.Translator;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassIndex;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ColumnTranslationResolverImpl
implements ColumnTranslationResolver {
    private static final Logger LOG = Logger.getLogger(ColumnTranslationResolverImpl.class);
    private static final String CONFIGURATION_ERROR_MESSAGE = "pzmodule.program.configuration.error";
    @Autowired
    private ConfigurationResolver configurationResolver;
    @Autowired
    private DocumentClassResolver documentClassResolver;
    @Autowired
    private Translator translator;

    @Override
    public ColumnTranslation resolve(ConfigurationDto configuration, boolean attached, DocumentClass documentClass) throws RecordProviderException {
        ColumnTranslation columnTranslation = new ColumnTranslation();
        List<ColumnDto> columns = this.configurationResolver.resolveColumns(configuration, attached);
        Map<String, DocumentClassIndex> indexes = this.documentClassResolver.resolveIndexes(documentClass);
        columnTranslation = this.resolveForColumns(columnTranslation, columns, indexes, documentClass);
        columnTranslation = this.resolveForSorters(columnTranslation, configuration.getAttachedSorters(), indexes, documentClass);
        columnTranslation = this.resolveForSorters(columnTranslation, configuration.getNotAttachedSorters(), indexes, documentClass);
        columnTranslation = this.resolveForGroupers(columnTranslation, configuration.getGroupingConfiguration().getAttachedGroupers(), indexes, documentClass);
        columnTranslation = this.resolveForGroupers(columnTranslation, configuration.getGroupingConfiguration().getNotAttachedGroupers(), indexes, documentClass);
        columnTranslation = this.resolveForSearchCriteria(columnTranslation, configuration.getSearch().getAttachedCriteria(), indexes, documentClass);
        columnTranslation = this.resolveForSearchCriteria(columnTranslation, configuration.getSearch().getNotAttachedCriteria(), indexes, documentClass);
        return columnTranslation;
    }

    private DocumentClassIndex getDocumentClassIndex(ColumnDto column, Map<String, DocumentClassIndex> indexes, DocumentClass documentClass) throws RecordProviderException {
        return this.getDocumentClassIndex(column.getDataIndex(), indexes, documentClass);
    }

    private DocumentClassIndex getDocumentClassIndex(SorterDto sorter, Map<String, DocumentClassIndex> indexes, DocumentClass documentClass) throws RecordProviderException {
        return this.getDocumentClassIndex(sorter.getProperty(), indexes, documentClass);
    }

    private DocumentClassIndex getDocumentClassIndex(GrouperDto grouper, Map<String, DocumentClassIndex> indexes, DocumentClass documentClass) throws RecordProviderException {
        return this.getDocumentClassIndex(grouper.getProperty(), indexes, documentClass);
    }

    private DocumentClassIndex getDocumentClassIndex(SearchCriterionDto searchCriterion, Map<String, DocumentClassIndex> indexes, DocumentClass documentClass) throws RecordProviderException {
        return this.getDocumentClassIndex(searchCriterion.getMapping(), indexes, documentClass);
    }

    private DocumentClassIndex getDocumentClassIndex(String dataIndex, Map<String, DocumentClassIndex> indexes, DocumentClass documentClass) throws RecordProviderException {
        DocumentClassIndex index = indexes.get(dataIndex);
        if (index == null && !StringUtils.equals((CharSequence)dataIndex, (CharSequence)"fileid")) {
            LOG.error((Object)("Indeks o nazwie " + dataIndex + " nie istnieje w klasie dokumentow o nazwie " + documentClass.getName()));
            throw new RecordProviderException(this.buildConfigurationErrorMessage());
        }
        return index;
    }

    private String buildConfigurationErrorMessage() {
        return this.translator.translateMessage(CONFIGURATION_ERROR_MESSAGE);
    }

    private ColumnTranslation resolveForColumns(ColumnTranslation columnTranslation, List<ColumnDto> columns, Map<String, DocumentClassIndex> indexes, DocumentClass documentClass) throws RecordProviderException {
        if (CollectionUtils.isNotEmpty(columns)) {
            for (ColumnDto column : columns) {
                DocumentClassIndex index;
                if (!StringUtils.isBlank((CharSequence)column.getExpression()) || (index = this.getDocumentClassIndex(column, indexes, documentClass)) == null) continue;
                String translation = this.documentClassResolver.resolveColumnName(index);
                columnTranslation.addTranslation(column.getDataIndex(), translation);
            }
        }
        return columnTranslation;
    }

    private ColumnTranslation resolveForSorters(ColumnTranslation columnTranslation, List<SorterDto> sorters, Map<String, DocumentClassIndex> indexes, DocumentClass documentClass) throws RecordProviderException {
        if (CollectionUtils.isNotEmpty(sorters)) {
            for (SorterDto sorter : sorters) {
                DocumentClassIndex index = this.getDocumentClassIndex(sorter, indexes, documentClass);
                if (index == null) continue;
                String translation = this.documentClassResolver.resolveColumnName(index);
                columnTranslation.addTranslation(sorter.getProperty(), translation);
            }
        }
        return columnTranslation;
    }

    private ColumnTranslation resolveForGroupers(ColumnTranslation columnTranslation, List<GrouperDto> groupers, Map<String, DocumentClassIndex> indexes, DocumentClass documentClass) throws RecordProviderException {
        if (CollectionUtils.isNotEmpty(groupers)) {
            for (GrouperDto grouper : groupers) {
                DocumentClassIndex index = this.getDocumentClassIndex(grouper, indexes, documentClass);
                if (index == null) continue;
                String translation = this.documentClassResolver.resolveColumnName(index);
                columnTranslation.addTranslation(grouper.getProperty(), translation);
            }
        }
        return columnTranslation;
    }

    private ColumnTranslation resolveForSearchCriteria(ColumnTranslation columnTranslation, List<SearchCriterionDto> searchCriteria, Map<String, DocumentClassIndex> indexes, DocumentClass documentClass) throws RecordProviderException {
        if (CollectionUtils.isNotEmpty(searchCriteria)) {
            for (SearchCriterionDto searchCriterion : searchCriteria) {
                DocumentClassIndex index = this.getDocumentClassIndex(searchCriterion, indexes, documentClass);
                if (index == null) continue;
                String translation = this.documentClassResolver.resolveColumnName(index);
                columnTranslation.addTranslation(searchCriterion.getMapping(), translation);
            }
        }
        return columnTranslation;
    }
}

