/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.parentvalue;

import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.info.support.ParentValues;
import com.suncode.plugin.pzmodule.resolver.parentvalue.ParentValueResolver;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class ParentValueResolverImpl
implements ParentValueResolver {
    @Override
    public String resolveConfigurationId(ConfigurationDto configuration, ParentValues parentValues) {
        if (this.shouldUseParentConfigurationId(configuration, parentValues)) {
            return parentValues.getConfigurationId();
        }
        return configuration.getConfigurationId();
    }

    @Override
    public String resolveProcessId(ConfigurationDto configuration, String processId, ParentValues parentValues) {
        if (this.shouldUseParentProcessId(configuration, parentValues)) {
            return parentValues.getProcessId();
        }
        return processId;
    }

    private boolean shouldUseParentConfigurationId(ConfigurationDto configuration, ParentValues parentValues) {
        return this.shouldUseParentValue(configuration, parentValues.getConfigurationId());
    }

    private boolean shouldUseParentProcessId(ConfigurationDto configuration, ParentValues parentValues) {
        return this.shouldUseParentValue(configuration, parentValues.getProcessId());
    }

    private boolean shouldUseParentValue(ConfigurationDto configuration, String parentValue) {
        return BooleanUtils.isTrue((Boolean)configuration.getPartialAttachmentConfiguration().getControlSubflows()) && StringUtils.isNotBlank((CharSequence)parentValue);
    }
}

