( function( Ext ) {
  var messages = Suncode.context( 'pzmodule' ).messages;

  Ext.define( 'Suncode.pzmodule.view.table.RecordTable', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.recordtable',
    requires: [ 'Suncode.pzmodule.view.column.RecordColumn', 'Suncode.pzmodule.view.toolbar.RecordTablePagingToolbar',
      'Suncode.pzmodule.feature.table.PanelFiltersFeature', 'Ext.ux.grid.FiltersFeature',
      'Ext.ux.grid.feature.MultiGroupingSummary', 'Suncode.pzmodule.view.window.SaveSettingsWindow',
      'Suncode.pzmodule.view.window.SettingsWindow', 'Suncode.pzmodule.view.filter.SubGroupsFilter',
      'Suncode.pzmodule.view.window.AttachmentWindow' ],
    CELL_ERROR_CLS: 'pzmodule-error-cell',
    ROW_ERROR_CLS: 'pzmodule-error-row',
    titleAlign: 'center',
    stateful: true,
    selModel: {
      model: 'MULTI',
      allowDeselect: true,
      pruneRemoved: false
    },
    multiSelect: true,
    columnLines: true,
    viewConfig: {
      enableTextSelection: true,
      markDirty: false
    },
    blockFirstSort: false,
    subGroupsFilter: {
      groupId: '',
      groupingField: '',
      groupingSumColumn: '',
      filters: new Array()
    },
    initiallyAttachedRecords: new Array(),
    initiallyAttachedAmounts: new Object(),
    initComponent: function() {
      var attached = this.isAttached();
      var configuration = this.configuration;
      var storeFields = new Array();
      var filters = new Array();
      var isEditable = false;
      var pagingDisabled = this.pagingDisabled;

      Ext.each( this.columns, function( column, index, columns ) {
        storeFields.push( {
          name: column.dataIndex,
          type: column.fieldType,
          dateFormat: 'Y-m-d'
        } );

        if ( this.filterable && column.filterable ) {
          filters.push( this.buildFilter( column ) );
        }

        if ( column.editable ) {
          isEditable = true;
        }

        if ( !Ext.isEmpty( column.fontSize ) ) {
          column.style = 'font-size: ' + column.fontSize + 'px;';
        }
      }, this );

      var store = Ext.create( 'Ext.data.Store', {
        autoLoad: attached,
        autoDestroy: true,
        autoSync: true,
        remoteFilter: !attached,
        sortOnLoad: false,
        sorters: this.storeSorters,
        groupers: this.storeGroupers,
        pageSize: pagingDisabled ? null : this.storePageSize,
        fields: storeFields,
        tableId: this.id,
        proxy: {
          type: 'rest',
          api: {
            read: 'api/record/read',
            update: 'api/record/update'
          },
          actionMethods : {
            read: 'POST',
            update: 'PUT'
          },
          reader: {
            type: 'json',
            root: 'data',
            idProperty: configuration.search.location.primaryKey.name,
            messageProperty: 'message'
          },
          extraParams: {
            configurationId: configuration.configurationId,
            processId : Suncode.context( 'pzmodule' ).processId,
            activityId: Suncode.context( 'pzmodule' ).activityId,
            parentValues: Ext.JSON.encode( {
              configurationId: Suncode.context( 'pzmodule' ).parentConfigurationId,
              processId: Suncode.context( 'pzmodule' ).parentProcessId,
            } ),
            activityContext: Ext.JSON.encode( Suncode.context( 'pzmodule' ).activityContext ),
            extraParameters: Ext.JSON.encode( Suncode.context( 'pzmodule' ).extraParameters ),
            attached: attached,
            preventCount: attached
          },
          timeout: 900000,
          noCache: false,
          pageParam: undefined
        },
        doSort: function( sorterFn ) {
          var table = Ext.getCmp( this.tableId );

          if ( this.remoteSort ) {
            this.load();
          } else if ( Ext.isEmpty( table ) || table.isAttached() ) {
            this.data.sortBy( sorterFn );
            this.fireEvent( 'datachanged', this );
            this.fireEvent( 'refresh', this );
          }

          this.fireEvent( 'sort', this, this.sorters.getRange() );
        }
      } );
      this.store = store;

      if ( attached ) {
        var buttonToolbarItems = new Array();
        buttonToolbarItems.push( {
          xtype: 'button',
          id: 'pz_detach_pz_button',
          itemId: 'detachButton',
          text: configuration.panelsConfiguration.detachButtonText,
          iconCls: 'dvnt-icon-link2'
        });
        buttonToolbarItems.push({
          xtype: 'tbseparator'
        } );
        buttonToolbarItems.push( {
          xtype: 'button',
          id: 'pz_detach_all_pz_button',
          itemId: 'detachAllButton',
          text: configuration.panelsConfiguration.detachAllButtonText,
          iconCls: 'dvnt-icon-link2'
        });
        if (!Ext.isEmpty(this.extraButtons)) {
          Ext.each(this.extraButtons,
              function (extraButton, index, extraButtons) {
                buttonToolbarItems.push({
                  xtype: 'tbseparator'
                });
                buttonToolbarItems.push(
                    Ext.create('Suncode.pzmodule.view.button.ExtraButton', {
                      text: extraButton.name,
                      action: extraButton.action
                    }));
              });
        }
        buttonToolbarItems.push( {
          xtype: 'tbseparator'
        } );
        buttonToolbarItems.push( {
          xtype: 'tbtext',
          text: messages( 'pzmodule.selected' ) + ':'
        } );
        buttonToolbarItems.push( {
          xtype: 'displayfield',
          itemId: 'selectedRecordsField',
          fieldBodyCls: 'pzmodule-toolbar-selected-records-field',
          fieldCls: 'dvnt-body2',
          value: '0',
          width: 30
        } );
        if ( !Ext.isEmpty( this.toolbarFields ) ) {
          Ext.each( this.toolbarFields, function ( toolbarField, index, toolbarFields ) {
            buttonToolbarItems.push( {
              xtype: 'tbseparator'
            } );
            buttonToolbarItems.push( {
              xtype: 'tbtext',
              text: toolbarField.label + ':'
            } );
            buttonToolbarItems.push( {
              xtype: 'textfield',
              itemId: toolbarField.id,
              readOnly: true,
              fieldCls: 'pzmodule-toolbar-number-field',
              value: this.buildToolbarFieldInitialValue( toolbarField.variableId ),
              width: toolbarField.width
            } );
          }, this );
        }
        buttonToolbarItems.push( {
          xtype: 'tbfill'
        } );
        buttonToolbarItems.push( {
          xtype: 'button',
          id: 'pz_save_button',
          itemId: 'saveButton',
          text: configuration.panelsConfiguration.saveButtonText,
          iconCls: 'dvnt-icon-save'
        });
        buttonToolbarItems.push({
          xtype: 'tbseparator'
        } );
        buttonToolbarItems.push( {
          xtype: 'button',
          id: 'pz_close_button',
          itemId: 'closeButton',
          text: configuration.panelsConfiguration.closeButtonText,
          iconCls: 'dvnt-icon-x-symbol'
        });

        this.bbar = Ext.create( 'Ext.toolbar.Toolbar', {
          id: 'pz_attached_bottomtoolbar',
          items: buttonToolbarItems
        } );
      } else {
        var topToolbarItems = new Array();
        if ( this.groupingMenuEnabled ) {
          topToolbarItems.push( {
            xtype: 'button',
            text: messages('pzmodule.settings'),
            iconCls: 'dvnt-icon-settings',
            menu: Ext.create('Ext.menu.Menu', {
              items: [{
                xtype: 'menuitem',
                itemId: 'saveSettingsItem',
                text: messages('pzmodule.save'),
                iconCls: 'dvnt-icon-save column-action-item-icon',
                table: this
              }, {
                xtype: 'menuitem',
                itemId: 'displaySettingsItem',
                text: messages('pzmodule.display'),
                iconCls: 'dvnt-icon-windows column-action-item-icon',
                table: this
              } ]
            } )
          } );
        }
        if ( this.filterable && ( !Ext.isEmpty( filters ) || !Ext.isEmpty( this.storeGroupers ) ||
            this.groupingMenuEnabled ) ) {
          topToolbarItems.push( {
            xtype: 'button',
            id: 'pz_clear_filters_button',
            itemId: 'clearFiltersButton',
            text: messages('pzmodule.clearfilters'),
            iconCls: 'dvnt-icon-delete'
          } );
        }

        if ( pagingDisabled ) {
          this.tbar = Ext.create( 'Ext.toolbar.Toolbar', {
            id: 'pz_not_attached_toptoolbar',
            items: topToolbarItems
          } );
        } else {
          topToolbarItems.push( {
            xtype: 'tbfill'
          } );

          this.tbar = Ext.create( 'Suncode.pzmodule.view.toolbar.RecordTablePagingToolbar', {
            id: 'pz_not_attached_toptoolbar',
            pageSize: this.storePageSize,
            store: store,
            excludeFirstPageButton: true,
            excludeLastPageButton: true,
            items: topToolbarItems
          } );
        }

        var buttonToolbarItems = new Array();
        buttonToolbarItems.push( {
          xtype: 'button',
          id: 'pz_attach_pz_button',
          itemId: 'attachButton',
          text: configuration.panelsConfiguration.attachButtonText,
          iconCls: 'dvnt-icon-link'
        });
        buttonToolbarItems.push({
          xtype: 'tbseparator'
        } );
        if ( configuration.panelsConfiguration.selectionButtonsInMenu ) {
          buttonToolbarItems.push( {
            xtype: 'button',
            iconCls: 'dvnt-icon-more-vertical',
            arrowCls: 'pzmodule-no-visibility',
            menu: Ext.create('Ext.menu.Menu', {
              items: [{
                xtype: 'menuitem',
                id: 'pz_select_all_not_attached_button',
                itemId: 'selectAllButton',
                text: messages('pzmodule.selectall'),
                iconCls: 'dvnt-icon-plus-square column-action-item-icon'
              }, {
                xtype: 'menuitem',
                id: 'pz_deselect_all_not_attached_button',
                itemId: 'deselectAllButton',
                text: messages('pzmodule.deselectall'),
                iconCls: 'dvnt-icon-minus-square column-action-item-icon'
              } ]
            } )
          } );
        } else {
          buttonToolbarItems.push( {
            xtype: 'button',
            id: 'pz_select_all_not_attached_button',
            itemId: 'selectAllButton',
            text: messages('pzmodule.selectall'),
            iconCls: 'dvnt-icon-plus-square'
          });
          buttonToolbarItems.push({
            xtype: 'tbseparator'
          } );
          buttonToolbarItems.push( {
            xtype: 'button',
            id: 'pz_deselect_all_not_attached_button',
            itemId: 'deselectAllButton',
            text: messages('pzmodule.deselectall'),
            iconCls: 'dvnt-icon-minus-square'
          });
        }
        if ( configuration.panelsConfiguration.toggleGroupsButtonEnabled
            && ( !Ext.isEmpty( this.storeGroupers ) || this.groupingMenuEnabled ) ) {
          buttonToolbarItems.push({
            xtype: 'tbseparator'
          } );
          buttonToolbarItems.push( {
            xtype: 'button',
            id: 'pz_collapse_groups_not_attached_button',
            itemId: 'collapseGroupsButton',
            text: messages('pzmodule.collapsegroups'),
            iconCls: 'dvnt-icon-up-straight'
          });
          buttonToolbarItems.push( {
            xtype: 'button',
            id: 'pz_expand_groups_not_attached_button',
            itemId: 'expandGroupsButton',
            text: messages('pzmodule.expandgroups'),
            iconCls: 'dvnt-icon-down-straight'
          });
        }
        if (!Ext.isEmpty(this.extraButtons)) {
          Ext.each(this.extraButtons,
              function (extraButton, index, extraButtons) {
                buttonToolbarItems.push({
                  xtype: 'tbseparator'
                });
                buttonToolbarItems.push(
                    Ext.create('Suncode.pzmodule.view.button.ExtraButton', {
                      text: extraButton.name,
                      action: extraButton.action
                    }));
              });
        }
        buttonToolbarItems.push( {
          xtype: 'tbseparator'
        } );
        buttonToolbarItems.push( {
          xtype: 'tbtext',
          text: messages( 'pzmodule.selected' ) + ':'
        } );
        buttonToolbarItems.push( {
          xtype: 'displayfield',
          itemId: 'selectedRecordsField',
          fieldBodyCls: 'pzmodule-toolbar-selected-records-field',
          fieldCls: 'dvnt-body2',
          value: '0',
          width: 30
        } );
        if ( !Ext.isEmpty( this.toolbarFields ) ) {
          Ext.each( this.toolbarFields, function ( toolbarField, index, toolbarFields ) {
            buttonToolbarItems.push( {
              xtype: 'tbseparator'
            } );
            buttonToolbarItems.push( {
              xtype: 'tbtext',
              text: toolbarField.label + ':'
            } );
            buttonToolbarItems.push( {
              xtype: 'textfield',
              itemId: toolbarField.id,
              readOnly: true,
              fieldCls: 'pzmodule-toolbar-number-field',
              value: this.buildToolbarFieldInitialValue( toolbarField.variableId ),
              width: toolbarField.width
            } );
          }, this );
        }

        this.bbar = Ext.create( 'Ext.toolbar.Toolbar', {
          id: 'pz_not_attached_bottomtoolbar',
          items: buttonToolbarItems
        } );
      }

      var features = new Array();
      if ( this.filterable && !Ext.isEmpty( filters ) ) {
        features.push( this.buildFiltersFeature( filters ) );
      }
      if ( !Ext.isEmpty( this.storeGroupers ) || this.groupingMenuEnabled ) {
        var table = this;
        var groupHeaderTpl = Ext.isEmpty( this.groupingSums ) ? '{columnName}: {name}' :
            [ '{[this.supplyGroupHeader(values)]}', {
              supplyGroupHeader: function( groupConfig ) {
                return table.supplyGroupHeader( groupConfig );
              }
            } ];

        features.push( Ext.create( 'Ext.ux.grid.feature.MultiGroupingSummary', {
          id: 'multigrouping',
          enableGroupingMenu: this.groupingMenuEnabled,
          startCollapsed: this.groupingStartCollapsed,
          enableGroupBy: false,
          enableNoGroups: false,
          showSummaryRow: false,
          groupHeaderTpl: groupHeaderTpl,
          groupByText: messages( 'pzmodule.groupBy' ),
          addGroupFieldText: messages( 'pzmodule.addToGrouping' ),
          ungroupFieldText: messages( 'pzmodule.removeFromGrouping' ),
          showGroupsText: messages( 'pzmodule.showGroups' )
        } ) );
      }
      this.features = features;

      var plugins = new Array();
      if ( attached && isEditable ) {
        plugins.push( {
          ptype: 'cellediting'
        } );
      }
      this.plugins = plugins;

      this.blockFirstSort = !Ext.isEmpty( this.storeSorters );

      this.callParent();
    },
    buildFilter: function( column ) {
      switch( this.filtersType ) {
        case 'menu':
          return {
            dataIndex: column.dataIndex,
            type: column.filterType,
            filtersInit: column.filtersInit
          };
        default:
          var panelFilterClass = Ext.ClassManager.getByAlias( 'gridpanelfilter.' + column.filterType );
          var filter = new panelFilterClass( {
            filterField: column.dataIndex,
            decimalSeparator: column.decimalSeparator,
            decimalPrecision: column.decimalPrecision,
            dateFormat: column.dateFormat,
            filtersInit: column.filtersInit
          } );
          column.layout = 'fit';
          column.items = [ filter ];

          return filter;
      }
    },
    buildFiltersFeature: function( filters ) {
      switch( this.filtersType ) {
        case 'menu':
          return {
            id: 'filters',
            ftype: 'filters',
            menuFilterText: messages( 'pzmodule.filters' ),
            encode: true,
            filters: filters,
            liveFiltering: this.configuration.liveFiltering
          };
        default:
          return {
            id: 'filters',
            ftype: 'panelfilters',
            filters: filters,
            liveFiltering: this.configuration.liveFiltering
          };
      }
    },
    getTable: function( attached ) {
      var tablesPanel = this.up( 'container[itemId=tablesPanel]' );

      return tablesPanel.down( 'recordtable[attached= ' + attached + ']' );
    },
    loadRecords: function() {
      var store = this.getStore();
      store.load();
    },
    reloadRecords: function() {
      var store = this.getStore();
      store.loadPage( 1 );
    },
    selectRecords: function( records ) {
      var selModel = this.getSelectionModel();
      selModel.select( records, true, true );
      this.updateSelectedRecordsField();
      this.updateToolbarFields( false );

      if ( !this.isAttached() ) {
        var selections = selModel.getSelection();
        this.callAction( this.configuration.javaScriptActions.select, [ selections ] );
      }
    },
    deselectRecords: function( records ) {
      var selModel = this.getSelectionModel();
      selModel.deselect( records, true );
      this.updateSelectedRecordsField();

      if ( !this.isAttached() ) {
        var selections = selModel.getSelection();
        this.callAction( this.configuration.javaScriptActions.deselect, [ selections ] );
      }
    },
    deselectAll: function() {
      var selModel = this.getSelectionModel();
      selModel.suspendEvent( 'deselect' );
      selModel.deselectAll();
      selModel.resumeEvent( 'deselect' );
      this.updateSelectedRecordsField();

      if ( !this.isAttached() ) {
        var selections = selModel.getSelection();
        this.callAction( this.configuration.javaScriptActions.deselect, [ selections ] );
      }
    },
    updateSelectedRecordsField: function() {
      var selectedRecordsField = this.getSelectedRecordsField();

      if ( !Ext.isEmpty( selectedRecordsField ) ) {
        var selModel = this.getSelectionModel();
        var selections = selModel.getSelection();
        selectedRecordsField.setValue( selections.length );
      }
    },
    updateToolbarFields: function ( includeSumAll ) {
      if ( !Ext.isEmpty( this.toolbarFields ) ) {
        Ext.each( this.toolbarFields, function ( toolbarField, fieldIndex, toolbarFields ) {
          if ( Ext.isEmpty( toolbarField.variableId ) ) {
            var field = this.getToolbarField( toolbarField.id );

            switch ( toolbarField.operation ) {
              case 'sum':
                var selModel = this.getSelectionModel();
                var records = selModel.getSelection();
                var value = this.sumRecordsField( records, toolbarField.columnId );

                field.setValue( value );
                break;
              case 'sumall':
                if ( includeSumAll ) {
                  if ( this.isAttached() ) {
                    var records = this.getStore().getRange();
                    var value = this.sumRecordsField( records, toolbarField.columnId );

                    field.setValue( value );
                  } else {
                    var configuration = this.configuration;
                    var options = {
                      params: {
                        filter: ''
                      }
                    };
                    var store = this.getStore();
                    var filtersFeature = this.getView().getFeature( 'filters' );
                    if ( !Ext.isEmpty( filtersFeature ) ) {
                      filtersFeature.onBeforeLoad( store, options );
                    }
                    var attachedTable = this.getTable( true );
                    var ids = attachedTable.getRecordIds();
                    var amounts = new Object();
                    if ( this.isPartialAttachmentShowMySeparatedActive() ) {
                      amounts = attachedTable.getAmounts();
                    }

                    Ext.Ajax.request( {
                      url: 'api/record/sumall',
                      method: 'POST',
                      params: {
                        configurationId: configuration.configurationId,
                        processId : Suncode.context( 'pzmodule' ).processId,
                        activityId: Suncode.context( 'pzmodule' ).activityId,
                        parentValues: Ext.JSON.encode( {
                          configurationId: Suncode.context( 'pzmodule' ).parentConfigurationId,
                          processId: Suncode.context( 'pzmodule' ).parentProcessId,
                        } ),
                        activityContext: Ext.JSON.encode( Suncode.context( 'pzmodule' ).activityContext ),
                        extraParameters: Ext.JSON.encode( Suncode.context( 'pzmodule' ).extraParameters ),
                        attached: this.isAttached(),
                        columnId: toolbarField.columnId,
                        ids: Ext.JSON.encode( ids ),
                        amounts: Ext.JSON.encode( amounts ),
                        filter: options.params.filter
                      },
                      timeout: 900000,
                      scope: this,
                      success: function( response, options ) {
                        var result = Ext.JSON.decode( response.responseText );

                        if ( result.success ) {
                          var sumAllResult = result.data;
                          var sum = sumAllResult.sum;
                          value = sum.toFixed( 2 );

                          field.setValue( value );
                        }
                      }
                    } );
                  }
                  break;
                }
              default:
                break;
            }
          }
        }, this);
      }
    },
    sumRecordsField: function( records, columnId ) {
      var value = 0;

      if ( !Ext.isEmpty( records ) ) {
        Ext.each( records, function ( record, recordIndex, allRecords ) {
          value += record.get( columnId );
        } );
      }
      return value.toFixed( 2 );
    },
    getSelectedRecordsField: function() {
      return this.down( 'displayfield[itemId=selectedRecordsField]' );
    },
    getToolbarField: function ( itemId ) {
      return this.down( 'textfield[itemId=' + itemId + ']' );
    },
    getRecordById: function( id ) {
      var store = this.getStore();

      return store.getById( id );
    },
    addRecord: function( record ) {
      var store = this.getStore();
      store.add( record );
    },
    addRecords: function( records ) {
      var store = this.getStore();
      store.add( records );
      store.sort();
    },
    reloadNotAttachedTable: function() {
      var ids = this.getRecordIds();
      var notAttachedTable = this.getTable( false );
      var proxy = notAttachedTable.getStore().getProxy();
      proxy.setExtraParam( 'ids', Ext.JSON.encode( ids ) );
      if ( this.isPartialAttachmentShowMySeparatedActive() ) {
        var amounts = this.getAmounts();
        proxy.setExtraParam( 'amounts', Ext.JSON.encode( amounts ) );
      }
      notAttachedTable.loadRecords();
    },
    getRecordIds: function() {
      var primaryKeyName = this.configuration.search.location.primaryKey.name;

      return this.getStore().collect( primaryKeyName, true, true );
    },
    isPartialAttachmentShowMySeparatedActive: function() {
      var partialAttachmentConfiguration = this.configuration.partialAttachmentConfiguration;

      return ( !Ext.isEmpty( partialAttachmentConfiguration.amountColumnId ) &&
          partialAttachmentConfiguration.showMySeparated );
    },
    getAmounts: function() {
      var amounts = new Object();
      var primaryKeyName = this.configuration.search.location.primaryKey.name;
      var amountColumnId = this.configuration.partialAttachmentConfiguration.amountColumnId;
      var presentPrimaryKeys = new Array();

      this.getStore().each( function( record ) {
        var primaryKeyValue = record.get( primaryKeyName );
        var amount = record.get( amountColumnId );
        var initiallyAttachedAmount = this.initiallyAttachedAmounts[primaryKeyValue];

        if ( Ext.isDefined( initiallyAttachedAmount ) ) {
          amounts[primaryKeyValue] = amount - initiallyAttachedAmount;
        } else {
          amounts[primaryKeyValue] = amount;
        }

        presentPrimaryKeys.push( primaryKeyValue ? primaryKeyValue.toString() : primaryKeyValue );
      }, this );

      Ext.iterate( this.initiallyAttachedAmounts, function( primaryKeyValue, initiallyAttachedAmount, myself ) {
        if ( presentPrimaryKeys.indexOf( primaryKeyValue ? primaryKeyValue.toString() : primaryKeyValue ) == -1 ) {
          amounts[primaryKeyValue] = ( -1 ) * initiallyAttachedAmount;
        }
      } );

      return amounts;
    },
    getGroupAmount: function( getGroups ) {
      var groupAmount = 0;
      var store = this.getStore();
      var collection = store.queryBy( function( record, id ) {
        var result = true;

        Ext.each( getGroups, function( group, index, groups ) {
          var groupValue = record.get( group.id );

          if ( groupValue != group.value ) {
            result = false;
            return false;
          }
        } );

        return result;
      } );

      if ( !Ext.isEmpty( collection ) ) {
        var primaryKeyName = this.configuration.search.location.primaryKey.name;
        var amountColumnId = this.configuration.partialAttachmentConfiguration.amountColumnId;

        Ext.each( collection.items, function( record, index, records ) {
          var primaryKeyValue = record.get( primaryKeyName );
          var amount = record.get( amountColumnId );
          var initiallyAttachedAmount = this.initiallyAttachedAmounts[primaryKeyValue];
          groupAmount += amount;

          if ( Ext.isDefined( initiallyAttachedAmount ) ) {
            groupAmount -= initiallyAttachedAmount;
          }
        }, this );
      }

      return groupAmount;
    },
    attach: function( records ) {
      this.resetSubGroupsFilter();
      var selModel = this.getSelectionModel();
      selModel.suspendEvent( 'deselect' );
      this.deselectAll();
      selModel.resumeEvent( 'deselect' );
      var attachedTable = this.getTable( true );

      if ( this.isPartialAttachmentShowMySeparatedActive() ) {
        var configuration = this.configuration;
        var amountColumnId = configuration.partialAttachmentConfiguration.amountColumnId;

        Ext.each( records, function( record, index, allRecords ) {
          var recordId = record.getId();
          var attachedRecord = attachedTable.getRecordById( recordId );

          if ( !Ext.isEmpty( attachedRecord ) ) {
            var amount = record.get( amountColumnId );
            var attachedAmount = attachedRecord.get( amountColumnId );

            attachedRecord.set( amountColumnId, amount + attachedAmount );
          } else {
            attachedTable.addRecord( record );
          }
        } );
      } else {
        attachedTable.addRecords( records );
      }

      attachedTable.reloadNotAttachedTable();
      this.updateToolbarFields( true );
      attachedTable.updateToolbarFields( true );
      var selections = selModel.getSelection();
      this.callAction( this.configuration.javaScriptActions.deselect, [ selections ] );
      var attachedRecords = attachedTable.getStore().getRange();
      attachedTable.callAction( attachedTable.configuration.javaScriptActions.attach, [ attachedRecords ] );
    },
    detach: function( records ) {
      var selModel = this.getSelectionModel();
      selModel.suspendEvent( 'deselect' );
      this.deselectAll();
      selModel.resumeEvent( 'deselect' );
      var store = this.getStore();
      store.suspendAutoSync();
      store.remove( records );
      store.resumeAutoSync();
      this.reloadNotAttachedTable();
      var notAttachedTable = this.getTable( false );
      notAttachedTable.updateToolbarFields( true );
      this.updateToolbarFields( true );
      this.callAction( this.configuration.javaScriptActions.detach, [ records ] );
    },
    detachAll: function() {
      var store = this.getStore();
      var records = store.getRange();
      var selModel = this.getSelectionModel();
      selModel.suspendEvent( 'deselect' );
      this.deselectAll();
      selModel.resumeEvent( 'deselect' );
      store.suspendAutoSync();
      store.removeAll();
      store.resumeAutoSync();
      this.reloadNotAttachedTable();
      var notAttachedTable = this.getTable( false );
      notAttachedTable.updateToolbarFields( true );
      this.updateToolbarFields( true );
      this.callAction( this.configuration.javaScriptActions.detach, [ records ] );
    },
    supplyGroupHeader: function( groupConfig ) {
      if ( this.shouldSumGroupRemotely( groupConfig ) ) {
        var remoteSumGroupTask = Ext.create( 'Ext.util.DelayedTask', this.sumGroupRemotely, this, [ groupConfig ] );
        remoteSumGroupTask.delay( 0 );

        return this.buildBasicGroupHeader( groupConfig );
      } else {
        var groupSumResults = this.sumGroupLocally( groupConfig );

        return this.buildGroupHeader( groupConfig, groupSumResults );
      }
    },
    shouldSumGroupRemotely: function( groupConfig ) {
      var store = this.getStore();
      var records = groupConfig.rows;
      var firstRecord = records.first();
      var lastRecord = records.last();
      var count = store.getCount();

      return ( !this.isAttached()
          && !this.isPagingDisabled()
          && ( ( store.indexOf( firstRecord ) == 0 && store.currentPage > 1 ) ||
              ( store.indexOf( lastRecord ) == count - 1 && count == store.pageSize ) ) );
    },
    sumGroupRemotely: function( groupConfig ) {
      var configuration = this.configuration;
      var groupId = groupConfig.groupId;
      var getGroups = this.buildGetGroups( groupId );
      var options = {
        params: {
          filter: ''
        }
      };
      var store = this.getStore();
      var filtersFeature = this.getView().getFeature( 'filters' );
      if ( !Ext.isEmpty( filtersFeature ) ) {
        filtersFeature.onBeforeLoad( store, options );
      }
      var attachedTable = this.getTable( true );
      var ids = attachedTable.getRecordIds();
      var amounts = new Object();
      var groupAmount = 0;
      if ( this.isPartialAttachmentShowMySeparatedActive() ) {
        amounts = attachedTable.getAmounts();
        groupAmount = attachedTable.getGroupAmount( getGroups );
      }
      var subGroupsFilter = this.getSubGroupsFilter();

      Ext.Ajax.request( {
        groupConfig: groupConfig,
        url: 'api/record/sum',
        method: 'POST',
        params: {
          configurationId: configuration.configurationId,
          processId : Suncode.context( 'pzmodule' ).processId,
          activityId: Suncode.context( 'pzmodule' ).activityId,
          parentValues: Ext.JSON.encode( {
            configurationId: Suncode.context( 'pzmodule' ).parentConfigurationId,
            processId: Suncode.context( 'pzmodule' ).parentProcessId,
          } ),
          activityContext: Ext.JSON.encode( Suncode.context( 'pzmodule' ).activityContext ),
          extraParameters: Ext.JSON.encode( Suncode.context( 'pzmodule' ).extraParameters ),
          attached: this.isAttached(),
          ids: Ext.JSON.encode( ids ),
          amounts: Ext.JSON.encode( amounts ),
          groupAmount: groupAmount,
          getGroups: Ext.JSON.encode( getGroups ),
          filter: options.params.filter,
          subGroupsFilter: Ext.JSON.encode( subGroupsFilter )
        },
        timeout: 900000,
        scope: this,
        success: this.onLoadGroupSum
      } );
    },
    sumGroupLocally: function( groupConfig ) {
      var store = this.getStore();
      var groupSumResults = new Array();

      Ext.each( this.groupingSums, function( groupingSum, index, groupingSums ) {
        var columnId = groupingSum.columnId;
        var sum = store.getSum( groupConfig.rows, columnId );

        groupSumResults.push( {
          columnId: columnId,
          sum: sum
        } );
      } );

      return groupSumResults;
    },
    buildGroupHeader: function( groupConfig, groupSumResults ) {
      var header = this.buildBasicGroupHeader( groupConfig );

      Ext.each( groupSumResults, function( result, index, results ) {
        var column = this.getColumn( result.columnId );

        if ( !Ext.isEmpty( column ) ) {
          header += ', ';
          header += messages( 'pzmodule.sumof' );
          header += ' \'';
          header += column.text;
          header += '\': ';
          header += column.formatColumnValue( result.sum );
        }
      }, this );

      return header;
    },
    buildBasicGroupHeader: function( groupConfig ) {
      var header = groupConfig.columnName;
      header += ': ';
      header += groupConfig.name;

      return header;
    },
    onLoadGroupSum: function( response, options ) {
      var result = Ext.JSON.decode( response.responseText );

      if ( result.success ) {
        var groupSumResults = result.data;
        var groupConfig = options.groupConfig;
        var groupTitleEl = this.getGroupTitleEl( groupConfig.groupId );

        if( !Ext.isEmpty( groupTitleEl ) ) {
          var newHtml = this.buildGroupHeader( groupConfig, groupSumResults );
          groupTitleEl.update( newHtml );
        }
      }
    },
    getGroupTitleEl: function( groupId ) {
      var tableEl = this.getEl();
      var groupEl = tableEl.getById( groupId );

      if( !Ext.isEmpty( groupEl ) ) {
        var groupTitleElCls = Ext.baseCSSPrefix + 'grid-group-title';
        var groupTitleEl = groupEl.down( 'div[class*=' + groupTitleElCls + ']' );

        if ( !Ext.isEmpty( groupTitleEl ) ) {
          return groupTitleEl;
        }
      }

      return null;
    },
    buildGetGroups: function( groupId ) {
      var getGroups = new Array();
      var multiGroupingFeature = this.getView().getFeature( 'multigrouping' );

      if ( !Ext.isEmpty( multiGroupingFeature ) ) {
        var realGroupId = multiGroupingFeature.getRealGroupId( groupId );
        var store = this.getStore();
        var groupers = store.groupers.items;

        Ext.each( realGroupId.split( '#_#' ), function( groupValue, index, groupValues ) {
          var grouper = groupers[index];
          getGroups.push( {
            id: !Ext.isEmpty( grouper ) ? grouper.property : null,
            value: groupValue
          } );
        } );
      }

      return getGroups;
    },
    callAction: function( action, args ) {
      if ( !Ext.isEmpty( action ) ) {
        try {
          var handler = this.getActionHandler( action );
          args = args ? args : [];
          Ext.Function.bind( handler ).apply( window, args );
        }
        catch ( exception ) {
          this.logException( exception );
        }
      }
    },
    getActionHandler: function( action ) {
      var table = action.split( '.' );
      var handler = window;

      Ext.each( table, function( part, index, parts ) {
        handler = handler[part];
      } );

      return handler;
    },
    logException: function( exception ) {
      if ( typeof console !== 'undefined' && Ext.isFunction( console.log ) && !Ext.isEmpty( exception ) ) {
        console.log( exception );
      }
    },
    isAttached: function() {
      return this.attached;
    },
    isPagingDisabled: function() {
      return this.pagingDisabled;
    },
    getColumn: function( dataIndex ) {
      var result = null;

      Ext.each( this.getView().headerCt.getGridColumns(), function( column, index, columns ) {
        if ( column.dataIndex == dataIndex ) {
          result = column;
          return false;
        }
      } );

      return result;
    },
    getVisibleColumnIndex: function( dataIndex ) {
      var result = -1;

      Ext.each( this.getView().headerCt.getVisibleGridColumns(), function( column, index, columns ) {
        if ( column.dataIndex == dataIndex ) {
          result = index;
          return false;
        }
      } );

      return result;
    },
    showWindowInCenter: function( win ) {
      var x = this.getX() + this.getWidth() / 2 - win.getWidth() / 2;
      var y = this.getY() + this.getHeight() / 2 - win.getHeight() / 2;
      win.setXY( [ x, y ] );
    },
    getRawRecords: function() {
      var records = new Array();
      var store = this.getStore();

      store.each( function( record ) {
        records.push( record.getData() );
      } );

      return records;
    },
    shouldRefreshPanelFilters: function() {
      return this.filtersType == 'panel';
    },
    refreshPanelFilters: function() {
      Ext.each( this.getView().headerCt.getVisibleGridColumns(), function( column, index, columns ) {
        if ( !Ext.isEmpty( column.flex ) ) {
          var panelFilter = column.items.first();

          if ( !Ext.isEmpty( panelFilter ) ) {
            if ( panelFilter.isHidden() ) {
              panelFilter.show();
            }

            panelFilter.setWidth( column.getWidth() - 5 );
          }
        }
      } );
    },
    clearFilters: function() {
      var filtersFeature = this.getView().getFeature( 'filters' );
      if ( !Ext.isEmpty( filtersFeature ) ) {
        filtersFeature.clearFilters();
      }

      this.resetSubGroupsFilter();
      this.reloadRecords();
    },
    shouldShowSubGroupsFilter: function( groupId ) {
      if ( this.filterable && !Ext.isEmpty( this.groupingSums ) ) {
        var store = this.getStore();

        return groupId.split( '#_#' ).length < store.groupers.getCount();
      } else {
        return false;
      }
    },
    getNextGroupingField: function( groupId ) {
      var store = this.getStore();
      var groupers = store.groupers.items
      var grouper = store.groupers.getAt( groupId.split( '#_#' ).length );

      if ( !Ext.isEmpty( grouper ) ) {
        return grouper.property;
      } else {
        return '';
      }
    },
    getSubGroupsFilter: function() {
      return this.subGroupsFilter;
    },
    getSubGroupsFilterByGroupId: function( groupId ) {
      var subGroupsFilter = this.getSubGroupsFilter();

      if ( subGroupsFilter.groupId == groupId ) {
        return subGroupsFilter;
      } else {
        return {
          groupId: '',
          groupingField: '',
          groupingSumColumn: '',
          filters: new Array()
        };
      }
    },
    updateSubGroupsFilter: function( groupId, groupingField, groupingSumColumn, filters ) {
      this.subGroupsFilter.groupId = groupId;
      this.subGroupsFilter.groupingField = groupingField;
      this.subGroupsFilter.groupingSumColumn = groupingSumColumn;
      this.subGroupsFilter.filters = Ext.Array.clone( filters );
      var getGroups = this.buildGetGroups( groupId );
      var proxy = this.getStore().getProxy();
      proxy.setExtraParam( 'subGroupsFilter', Ext.JSON.encode( this.getSubGroupsFilter() ) );
      proxy.setExtraParam( 'getGroups', Ext.JSON.encode( getGroups ) );
    },
    resetSubGroupsFilter: function() {
      this.subGroupsFilter.groupId = '';
      this.subGroupsFilter.groupingField = '';
      this.subGroupsFilter.groupingSumColumn = '';
      Ext.Array.erase( this.subGroupsFilter.filters, 0, this.subGroupsFilter.filters.length );
      var proxy = this.getStore().getProxy();
      proxy.setExtraParam( 'subGroupsFilter', null );
      proxy.setExtraParam( 'getGroups', null );
    },
    shouldMarkFilteredGroup: function() {
      var subGroupsFilter = this.getSubGroupsFilter();

      return !( Ext.isEmpty( subGroupsFilter.groupingField ) || Ext.isEmpty( subGroupsFilter.groupingSumColumn )
          || Ext.isEmpty( subGroupsFilter.filters ) );
    },
    markFilteredGroup: function() {
      var subGroupsFilter = this.getSubGroupsFilter();
      var groupTitleEl = this.getGroupTitleEl( subGroupsFilter.groupId );

      if( !Ext.isEmpty( groupTitleEl ) ) {
        groupTitleEl.addCls( 'pzmodule-filtered-group' );
      }
    },
    getInitiallyAttachedRecords: function() {
      return this.initiallyAttachedRecords;
    },
    setInitiallyAttachedRecords: function( records ) {
      if ( !Ext.isEmpty( records ) ) {
        var showMySeparatedActive = this.isPartialAttachmentShowMySeparatedActive();
        var configuration = this.configuration;
        var primaryKeyName = configuration.search.location.primaryKey.name;
        var amountColumnId = configuration.partialAttachmentConfiguration.amountColumnId;

        Ext.each( records, function( record, index, allRecords ) {
          this.initiallyAttachedRecords.push( record.getData() );

          if ( showMySeparatedActive ) {
            var primaryKeyValue = record.get( primaryKeyName );
            var amount = record.get( amountColumnId );

            this.initiallyAttachedAmounts[primaryKeyValue] = amount;
          }
        }, this );
      }
    },
    markErrorCell: function( rowIndex, columnId ) {
      var el = this.getCellEl( rowIndex, columnId );

      if ( !Ext.isEmpty( el ) ) {
        el.addCls( this.CELL_ERROR_CLS );
      }
    },
    getCellEl: function( rowIndex, columnId ) {
      var row = this.getView().getNode( rowIndex );

      if ( !Ext.isEmpty( row ) ) {
        var colIndex = this.getVisibleColumnIndex( columnId );
        var cell = Ext.fly( Ext.fly( row ).query( '.' + Ext.baseCSSPrefix + 'grid-cell' )[colIndex] );

        if ( !Ext.isEmpty( cell ) ) {
          return cell.down( 'div' );
        }
      }
    },
    markErrorRow: function( rowIndex ) {
      this.getView().addRowCls( rowIndex, this.ROW_ERROR_CLS );
    },
    buildToolbarFieldInitialValue: function( variableId ) {
      if ( !Ext.isEmpty( variableId ) ) {
        var activityContext = Suncode.context( 'pzmodule' ).activityContext;

        return activityContext[variableId];
      } else {
        var value = '0';
        value += this.configuration.decimalSeparator;
        value += '00';

        return value;
      }
    }
  } );
}( this.Ext4 ) );