( function( Ext ) {
	var messages = Suncode.context( 'pzmodule' ).messages;
	
    Ext.define( 'Suncode.pzmodule.view.table.AttachmentTable', {
        extend: 'Ext.grid.Panel',
        alias: 'widget.attachmenttable',
        id: 'pz_attaching_grid',
        stateful: true,
        stateId: 'pz_attaching_grid_state_id',
        selModel: {
            model: 'MULTI',
            allowDeselect: true
        },
        multiSelect: true,
        border: 0,
        columnLines: true,
        viewConfig: {
            enableTextSelection: true,
            markDirty: false
        },
        initComponent: function() {
        	var configuration = this.table.configuration;
        	var tableColumns = new Array();
        	var groupers = configuration.groupingConfiguration.attachedGroupers;
        	var storeFields = new Array();
        	var menuEnabled = configuration.groupingConfiguration.attachedMenuEnabled;
        	var groupingSums = configuration.groupingConfiguration.attachedGroupSums;
        	
        	Ext.each( configuration.attachedColumns, function( column, index, columns ) {
        		var tableColumn = Ext.clone( column );
        		tableColumn = Ext.apply( tableColumn, {
        			id: 'attaching_' + tableColumn.id
        		} );
        		tableColumns.push( tableColumn );
        		
        		storeFields.push( {
        			name: column.dataIndex,
        			type: column.fieldType,
        			dateFormat: 'Y-m-d'
        		} );
        		
        		if ( column.editable ) {
        			isEditable = true;
        		}
        	}, this );
        	this.columns = tableColumns;
        	
            this.store = Ext.create( 'Ext.data.Store', {
                autoDestroy: true,
                autoSync: true,
                sortOnLoad: false,
                data: this.records,
                sorters: configuration.attachedSorters,
                groupers: groupers,
                fields: storeFields,
                proxy: {
                    type: 'rest',
                    api: {
                        update: 'api/record/update'
                    },
                    actionMethods : {
                        update: 'PUT'
                    },
                    reader: {
                        type: 'json',
                        root: 'data',
                        idProperty: configuration.search.location.primaryKey.name,
                        messageProperty: 'message'
                    },
                    extraParams: {
                        configurationId: configuration.configurationId,
                        attached: true
                    },
                    timeout: 900000,
                    noCache: false,
                    pageParam: undefined
                }
            } );
            
            var features = new Array();
            if ( !Ext.isEmpty( groupers ) || menuEnabled ) {
            	var table = this;
            	var groupHeaderTpl = Ext.isEmpty( groupingSums ) ? '{columnName}: {name}' :
            		[ '{[this.supplyGroupHeader(values)]}', {
            			supplyGroupHeader: function( groupConfig ) {
            				return table.supplyGroupHeader( groupConfig );
            			}
            		} ];
            	
            	features.push( Ext.create( 'Ext.ux.grid.feature.MultiGroupingSummary', {
            		id: 'multigrouping',
                    enableGroupingMenu: menuEnabled,
                    startCollapsed: configuration.groupingConfiguration.attachedStartCollapsed,
                    enableGroupBy: false,
                    enableNoGroups: false,
                    showSummaryRow: false,
                    groupHeaderTpl: groupHeaderTpl,
                    groupByText: messages( 'pzmodule.groupBy' ),
                    addGroupFieldText: messages( 'pzmodule.addToGrouping' ),
                    ungroupFieldText: messages( 'pzmodule.removeFromGrouping' ),
                    showGroupsText: messages( 'pzmodule.showGroups' )
                } ) );
            }
            this.features = features;
            
            var plugins = new Array();
            if ( isEditable ) {
            	plugins.push( {
            		ptype: 'cellediting'
            	} );
            }
            this.plugins = plugins;
            
            this.callParent();
        },
        supplyGroupHeader: function( groupConfig ) {
        	var groupSumResults = this.sumGroupLocally( groupConfig );
    		
    		return this.buildGroupHeader( groupConfig, groupSumResults );
        },
        sumGroupLocally: function( groupConfig ) {
        	var store = this.getStore();
        	var groupSumResults = new Array();
        	var configuration = this.table.configuration;
        	
        	Ext.each( configuration.groupingConfiguration.attachedGroupSums, function( groupingSum, index, groupingSums ) {
        		var columnId = groupingSum.columnId;
        		var sum = store.getSum( groupConfig.rows, columnId );
        		
        		groupSumResults.push( {
        			columnId: columnId,
        			sum: sum
        		} );
        	} );
    		
    		return groupSumResults;
        },
        buildGroupHeader: function( groupConfig, groupSumResults ) {
        	var header = this.buildBasicGroupHeader( groupConfig );
        	
        	Ext.each( groupSumResults, function( result, index, results ) {
        		var column = this.getColumn( result.columnId );
            	
            	if ( !Ext.isEmpty( column ) ) {
            		header += ', ';
            		header += messages( 'pzmodule.sumof' );
            		header += ' \'';
            		header += column.text;
            		header += '\': ';
            		header += column.formatColumnValue( result.sum );
            	}
        	}, this );
        	
        	return header;
        },
        buildBasicGroupHeader: function( groupConfig ) {
        	var header = groupConfig.columnName;
        	header += ': ';
        	header += groupConfig.name;
        	
        	return header;
        },
        getColumn: function( dataIndex ) {
            var result = null;
            
            Ext.each( this.getView().headerCt.getGridColumns(), function( column, index, columns ) {
            	if ( column.dataIndex == dataIndex ) {
            		result = column;
            		return false;
            	}
            } );
            
            return result;
        }
    } );
}( this.Ext4 ) );