( function( Ext ) {
	var messages = Suncode.context( 'pzmodule' ).messages;
	
	Ext.define( 'Suncode.pzmodule.view.panel.DocumentsPanel', {
        extend: 'Ext.tab.Panel',
        alias: 'widget.documentspanel',
        requires: [ 'Suncode.pzmodule.view.panel.DocumentPanel' ],
        id: 'pz_document_tab_panel',
        stateful: true,
        stateId: 'pz_right_panel_state_id',
        collapsible: true,
        titleCollapse: true,
        animCollapse: false,
        titleAlign: 'center',
        initComponent: function() {
        	var topToolbarItems = new Array();
        	topToolbarItems.push( {
            	xtype: 'button',
            	id: 'pz_new_window_doc_button',
            	itemId: 'enlargeDocumentButton',
            	text: messages( 'pzmodule.enlarge' ),
            	iconCls: 'dvnt-icon-zoom-in'
            } );
        	topToolbarItems.push( {
            	xtype: 'tbseparator'
            } );
        	topToolbarItems.push( {
            	xtype: 'button',
            	id: 'pz_close_all_tabs_button',
            	itemId: 'closeAllButton',
            	text: messages( 'pzmodule.closeall' ),
            	iconCls: 'dvnt-icon-x-symbol'
            } );
        	topToolbarItems.push( {
            	xtype: 'tbseparator'
            } );
        	topToolbarItems.push( {
            	xtype: 'button',
            	id: 'pz_display_process_docs_button',
            	itemId: 'restoreAllButton',
            	text: messages( 'pzmodule.processdocuments' ),
            	iconCls: 'dvnt-icon-right'
            } );
        	if ( !Ext.isEmpty( this.extraButtons ) ) {
        		Ext.each( this.extraButtons, function( extraButton, index, extraButtons ) {
        			topToolbarItems.push( {
                		xtype: 'tbseparator'
                	} );
        			topToolbarItems.push( Ext.create( 'Suncode.pzmodule.view.button.ExtraButton', {
        				text: extraButton.name,
        				action: extraButton.action
        			} ) );
        		} );
        	}
        	
        	this.tbar = Ext.create( 'Ext.toolbar.Toolbar', {
        		id: 'pz_right_panel_top_toolbar',
            	items: topToolbarItems
            } );
        	
            var items = new Array();
            if ( !Ext.isEmpty( this.documents ) ) {
                Ext.each( this.documents, function( document, index, documents ){
                	items.push( Ext.create( 'Suncode.pzmodule.view.panel.DocumentPanel', {
                		title: document.name,
                		document: document
                    } ) );
                });
            }

            this.items = items;

            this.callParent( arguments );
        }
    } );
}( this.Ext4 ) );