(function (Ext) {
  var messages = Suncode.context('pzmodule').messages;

  Ext.define('Suncode.pzmodule.controller.table.AttachmentTableController', {
    extend: 'Ext.app.Controller',
    init: function () {
      this.control({
        'attachmenttable': {
          afterrender: this.onAfterRender,
          beforestatesave: this.onBeforeStateSave
        }
      });
    },
    onAfterRender: function (table, eOpts) {
      var store = table.getStore();
      store.addListener('beforesync', this.onBeforeSync, table);
      store.addListener('update', this.onRecordUpdate, table);
    },
    onBeforeSync: function (options, eOpts) {
      if (!Ext.isEmpty(options.update)) {
        this.getEl().mask(messages('pzmodule.updateinprogress'));
      }
    },
    onRecordUpdate: function (store, record, operation, modifiedFieldNames,
        eOpts) {
      this.getEl().unmask();
    },
    onBeforeStateSave: function (stateful, state, eOpts) {
      if (!Ext.isEmpty(state.storeState)) {
        delete state.storeState.groupers;
        delete state.storeState.sorters;
      }
    }
  });
}(this.Ext4));