(function (Ext) {
  Ext.define('Suncode.pzmodule.controller.panel.DocumentPanelController', {
    extend: 'Ext.app.Controller',
    init: function () {
      this.control({
        'documentpanel': {
          activate: this.onActivate,
          deactivate: this.onDeactivate
        }
      });
    },
    onActivate: function (panel, eOpts) {
      var src = Suncode.context('pzmodule').contextPath + '/'
          + panel.document.previewLink;
      this.applyDocumentSrc(panel, src);
    },
    onDeactivate: function (panel, eOpts) {
      this.applyDocumentSrc(panel, '');
    },
    applyDocumentSrc: function (panel, src) {
      var dom = panel.getEl().dom;

      Ext.apply(dom, {
        src: src
      });
    }
  });
}(this.Ext4));