/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.web.support.dto.settings.extractor;

import com.suncode.plugin.pzmodule.model.settings.GroupingSettings;
import com.suncode.plugin.pzmodule.model.settings.Settings;
import com.suncode.plugin.pzmodule.model.settings.SortingSettings;
import com.suncode.plugin.pzmodule.web.rest.support.form.SaveSettingsForm;
import com.suncode.plugin.pzmodule.web.support.dto.settings.extractor.GroupingSettingsDtoExtractor;
import com.suncode.plugin.pzmodule.web.support.dto.settings.extractor.SaveSettingsFormExtractor;
import com.suncode.plugin.pzmodule.web.support.dto.settings.extractor.SortingSettingsDtoExtractor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SaveSettingsFormExtractorImpl
implements SaveSettingsFormExtractor {
    @Autowired
    private GroupingSettingsDtoExtractor groupingSettingsDtoExtractor;
    @Autowired
    private SortingSettingsDtoExtractor sortingSettingsDtoExtractor;

    @Override
    public Settings extract(String ownerId, SaveSettingsForm form) {
        Settings entity = new Settings();
        entity.setAttached(form.getAttached());
        entity.setOwnerId(ownerId);
        entity.setConfigurationId(form.getConfigurationId());
        entity.setName(form.getName());
        entity.setIsDefault(form.getIsDefault());
        entity.setShared(form.getShared());
        entity.setGroupingSettings(this.extractGroupingSettings(form));
        entity.setSortingSettings(this.extractSortingSettings(form));
        return entity;
    }

    private GroupingSettings extractGroupingSettings(SaveSettingsForm form) {
        return this.groupingSettingsDtoExtractor.extract(form.getGroupingSettings());
    }

    private SortingSettings extractSortingSettings(SaveSettingsForm form) {
        return this.sortingSettingsDtoExtractor.extract(form.getSortingSettings());
    }
}

