/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.web.rest;

import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.exception.ManageConfigurationException;
import com.suncode.plugin.pzmodule.service.configuration.AdministrationConfigurationService;
import com.suncode.plugin.pzmodule.web.rest.support.DatumResult;
import com.suncode.plugin.pzmodule.web.rest.support.Result;
import com.suncode.plugin.pzmodule.web.rest.support.builder.ResultBuilder;
import com.suncode.plugin.pzmodule.web.rest.support.form.ManageConfigurationForm;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/administration/configuration"})
public class AdministrationConfigurationController {
    private static final String DOWNLOAD_DATE_TIME_FORMAT = "yyyy-MM-dd HH_mm_ss";
    @Autowired
    private AdministrationConfigurationService administrationConfigurationService;
    @Autowired
    private ResultBuilder resultBuilder;

    @RequestMapping(value={"read"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ConfigurationDto> read() {
        return this.administrationConfigurationService.findAll();
    }

    @RequestMapping(value={"create"}, method={RequestMethod.POST})
    @ResponseBody
    public Result create(ManageConfigurationForm form) {
        try {
            this.administrationConfigurationService.add(form);
        }
        catch (ManageConfigurationException exception) {
            return this.buildErrorResult(exception.getMessage());
        }
        return this.buildSuccessResult();
    }

    @RequestMapping(value={"/get/{id}"}, method={RequestMethod.GET})
    @ResponseBody
    public DatumResult<ConfigurationDto> get(@PathVariable(value="id") Long id) {
        return this.administrationConfigurationService.find(id);
    }

    @RequestMapping(value={"update/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public Result update(@PathVariable(value="id") Long id, ManageConfigurationForm form) {
        try {
            this.administrationConfigurationService.edit(id, form);
        }
        catch (ManageConfigurationException exception) {
            return this.buildErrorResult(exception.getMessage());
        }
        return this.buildSuccessResult();
    }

    @RequestMapping(value={"/delete/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void delete(@PathVariable(value="id") Long id) {
        this.administrationConfigurationService.remove(id);
    }

    @RequestMapping(value={"/download/{id}"}, method={RequestMethod.POST})
    @ResponseBody
    public HttpEntity<byte[]> download(@PathVariable(value="id") Long id, @RequestParam String configurationId) {
        byte[] template = this.downloadConfiguration(id);
        HttpHeaders responseHeaders = this.buildDownloadConfigurationHeaders(template, configurationId);
        return new HttpEntity((Object)template, (MultiValueMap)responseHeaders);
    }

    private byte[] downloadConfiguration(Long id) {
        return this.administrationConfigurationService.download(id);
    }

    private HttpHeaders buildDownloadConfigurationHeaders(byte[] template, String configurationId) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.APPLICATION_XML);
        responseHeaders.setContentLength((long)ArrayUtils.getLength((Object)template));
        responseHeaders.setContentDispositionFormData("attachment", this.buildConfigurationFileName(configurationId));
        return responseHeaders;
    }

    private String buildConfigurationFileName(String configurationId) {
        StringBuilder fileName = new StringBuilder();
        fileName.append(configurationId);
        fileName.append(" ");
        fileName.append(AdministrationConfigurationController.buildFormattedDate());
        fileName.append(".xml");
        return fileName.toString();
    }

    public static String buildFormattedDate() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat dateFormat = new SimpleDateFormat(DOWNLOAD_DATE_TIME_FORMAT);
        return dateFormat.format(date);
    }

    private Result buildSuccessResult() {
        return this.resultBuilder.build();
    }

    private Result buildErrorResult(String message) {
        return this.resultBuilder.buildError(message);
    }
}

