/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.service.xml;

import com.suncode.plugin.pzmodule.api.enumeration.ColumnAlignment;
import com.suncode.plugin.pzmodule.api.enumeration.ColumnType;
import com.suncode.plugin.pzmodule.model.configuration.Button;
import com.suncode.plugin.pzmodule.model.configuration.Column;
import com.suncode.plugin.pzmodule.model.configuration.Configuration;
import com.suncode.plugin.pzmodule.model.configuration.DocumentFilter;
import com.suncode.plugin.pzmodule.model.configuration.ExternalJavaScriptFile;
import com.suncode.plugin.pzmodule.model.configuration.FilterInit;
import com.suncode.plugin.pzmodule.model.configuration.FilterRelation;
import com.suncode.plugin.pzmodule.model.configuration.FiltersInit;
import com.suncode.plugin.pzmodule.model.configuration.GroupSum;
import com.suncode.plugin.pzmodule.model.configuration.Grouper;
import com.suncode.plugin.pzmodule.model.configuration.GroupingConfiguration;
import com.suncode.plugin.pzmodule.model.configuration.JavaScriptActions;
import com.suncode.plugin.pzmodule.model.configuration.PanelsConfiguration;
import com.suncode.plugin.pzmodule.model.configuration.PartialAttachmentConfiguration;
import com.suncode.plugin.pzmodule.model.configuration.PrimaryKey;
import com.suncode.plugin.pzmodule.model.configuration.RelatedFilter;
import com.suncode.plugin.pzmodule.model.configuration.Save;
import com.suncode.plugin.pzmodule.model.configuration.SaveAction;
import com.suncode.plugin.pzmodule.model.configuration.SaveActionParameter;
import com.suncode.plugin.pzmodule.model.configuration.Search;
import com.suncode.plugin.pzmodule.model.configuration.SearchCriterion;
import com.suncode.plugin.pzmodule.model.configuration.SearchLocation;
import com.suncode.plugin.pzmodule.model.configuration.Sorter;
import com.suncode.plugin.pzmodule.model.configuration.ToolbarField;
import com.suncode.plugin.pzmodule.service.xml.ConfigurationUnmarshaller;
import com.suncode.plugin.pzmodule.service.xml.XmlConstants;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.util.IOUtils;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Service
public class ConfigurationUnmarshallerImpl
implements ConfigurationUnmarshaller {
    private static final XPath XPATH = XPathFactory.newInstance().newXPath();

    @Override
    public Configuration unmarshall(Configuration configuration, InputStream inputStream) throws Exception {
        Document document = this.getXml(inputStream);
        Element root = document.getDocumentElement();
        List<Column> columns = this.unmarshallColumns(root);
        PartialAttachmentConfiguration partialAttachmentConfiguration = this.unmarshallPartialAttachmentConfiguration(root);
        List<String> editableColumnIds = this.unmarshallEditableColumnIds(root, partialAttachmentConfiguration);
        configuration.setExternalJavaScriptFiles(this.unmarshallExternalJavaScriptFiles(root));
        configuration.setJavaScriptActions(this.unmarshallJavaScriptActions(root));
        configuration.setSearch(this.unmarshallSearch(root));
        configuration.setTableFontSize(this.unmarshallTableFontSize(root));
        configuration.setEditableColumnBackgroundColor(this.unmarshallEditableColumnBackgroundColor(root));
        configuration.setPanelsConfiguration(this.unmarshallPanelsConfiguration(root));
        configuration.setAttachedColumns(this.convertColumnsToAttached(columns, editableColumnIds));
        configuration.setNotAttachedColumns(columns);
        configuration.setGroupingConfiguration(this.unmarshallGroupingConfiguration(root));
        configuration.setAttachedSorters(this.unmarshallAttachedSorters(root));
        configuration.setNotAttachedSorters(this.unmarshallNotAttachedSorters(root));
        configuration.setAttachmentWindow(this.unmarshallAttachmentWindow(root));
        configuration.setNewWindowDocumentPreview(this.unmarshallNewWindowDocumentPreview(root));
        configuration.setDecimalSeparator(this.unmarshallDecimalSeparator(root));
        configuration.setLiveFiltering(this.unmarshallLiveFiltering(root));
        configuration.setEnableDuplicateChoice(this.unmarshallEnableDuplicateChoice(root));
        configuration.setButtons(this.unmarshallButtons(root));
        configuration.setToolbarFields(this.unmarshallToolbarFields(root));
        configuration.setFilterRelations(this.unmarshallFilterRelations(root));
        configuration.setPartialAttachmentConfiguration(partialAttachmentConfiguration);
        configuration.setSave(this.unmarshallSave(root));
        return configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document getXml(InputStream inputStream) throws Exception {
        Document document;
        InputStreamReader inputStreamReader = null;
        InputSource inputSource = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            inputSource = new InputSource(inputStreamReader);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document2 = documentBuilder.parse(inputSource);
            document2.normalize();
            document = document2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(inputStreamReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)inputStreamReader);
        return document;
    }

    private List<Column> unmarshallColumns(Element element) throws XPathExpressionException {
        ArrayList<Column> columns = new ArrayList<Column>();
        NodeList columnsList = (NodeList)XPATH.evaluate("Columns/Column", element, XPathConstants.NODESET);
        for (Element columnElement : this.convertToElementsList(columnsList)) {
            columns.add(this.unmarshallColumn(columnElement));
        }
        return columns;
    }

    private Column unmarshallColumn(Element element) throws XPathExpressionException {
        String type = this.getText(element, "Type");
        Column column = new Column();
        column.setColumnId(this.getText(element, "Id"));
        column.setName(this.getText(element, "Name"));
        column.setType(type);
        column.setFormat(this.getText(element, "Type", "format"));
        column.setInputFormat(this.getText(element, "Type", "inputFormat"));
        column.setFilterable(this.getLogical(element, "Filter"));
        column.setHidden(this.getLogical(element, "Hidden"));
        column.setHiddenInAttached(this.getLogical(element, "HiddenInAttached"));
        column.setWordWrap(this.getLogical(element, "WordWrap"));
        column.setCellTooltip(this.getLogical(element, "CellTooltip"));
        column.setWidth(this.getInteger(element, "Width"));
        column.setAlign(this.unmarshallAlign(element, type));
        column.setFiltersInit(this.unmarshallFiltersInit(element));
        column.setExpression(this.getText(element, "Expression"));
        return column;
    }

    private String unmarshallAlign(Element element, String type) throws XPathExpressionException {
        String align = this.getText(element, "Align");
        if (align != null && ColumnAlignment.existsByName(align)) {
            return align;
        }
        return this.unmarshallDefaultAlign(type);
    }

    private String unmarshallDefaultAlign(String type) {
        switch (ColumnType.getByName(type)) {
            case INT: 
            case FLOAT: {
                return ColumnAlignment.RIGHT.getName();
            }
            case DATE: 
            case DATE_STRING: {
                return ColumnAlignment.CENTER.getName();
            }
        }
        return ColumnAlignment.LEFT.getName();
    }

    private FiltersInit unmarshallFiltersInit(Element element) throws XPathExpressionException {
        FiltersInit filtersInit = new FiltersInit();
        Node filtersInitNode = (Node)XPATH.evaluate("FiltersInit", element, XPathConstants.NODE);
        if (this.isElement(filtersInitNode)) {
            Element filtersInitElement = (Element)filtersInitNode;
            filtersInit.setEq(this.unmarshallFilterInit(filtersInitElement, "Eq"));
            filtersInit.setGt(this.unmarshallFilterInit(filtersInitElement, "Gt"));
            filtersInit.setLt(this.unmarshallFilterInit(filtersInitElement, "Lt"));
        }
        return filtersInit;
    }

    private FilterInit unmarshallFilterInit(Element element, String nodeName) throws XPathExpressionException {
        Node filterInitNode = (Node)XPATH.evaluate(nodeName, element, XPathConstants.NODE);
        if (this.isElement(filterInitNode)) {
            FilterInit filterInit = new FilterInit();
            Element filterInitElement = (Element)filterInitNode;
            filterInit.setType(this.getAttribute(filterInitElement, "type"));
            filterInit.setValue(this.getText(filterInitElement));
            return filterInit;
        }
        return null;
    }

    private List<String> unmarshallEditableColumnIds(Element element, PartialAttachmentConfiguration partialAttachmentConfiguration) throws XPathExpressionException {
        ArrayList<String> editableColumnIds = new ArrayList<String>();
        String amountColumnId = partialAttachmentConfiguration.getAmountColumnId();
        NodeList editableColumnIdsList = (NodeList)XPATH.evaluate("Attaching/Column", element, XPathConstants.NODESET);
        for (Element editableColumnIdElement : this.convertToElementsList(editableColumnIdsList)) {
            editableColumnIds.add(this.getText(editableColumnIdElement));
        }
        if (StringUtils.isNotBlank((CharSequence)amountColumnId) && !editableColumnIds.contains(amountColumnId)) {
            editableColumnIds.add(amountColumnId);
        }
        return editableColumnIds;
    }

    private List<ExternalJavaScriptFile> unmarshallExternalJavaScriptFiles(Element element) throws XPathExpressionException {
        ArrayList<ExternalJavaScriptFile> externalJavaScriptFiles = new ArrayList<ExternalJavaScriptFile>();
        NodeList javaScriptFilesList = (NodeList)XPATH.evaluate("ImportJavaScript/JavaScriptFile", element, XPathConstants.NODESET);
        for (Element javaScriptFileElement : this.convertToElementsList(javaScriptFilesList)) {
            externalJavaScriptFiles.add(this.unmarshallExternalJavaScriptFile(javaScriptFileElement));
        }
        return externalJavaScriptFiles;
    }

    private ExternalJavaScriptFile unmarshallExternalJavaScriptFile(Element element) {
        ExternalJavaScriptFile externalJavaScriptFile = new ExternalJavaScriptFile();
        externalJavaScriptFile.setFileName(this.getText(element));
        return externalJavaScriptFile;
    }

    private JavaScriptActions unmarshallJavaScriptActions(Element element) throws XPathExpressionException {
        JavaScriptActions javaScriptActions = new JavaScriptActions();
        Node javaScriptActionsNode = (Node)XPATH.evaluate("JavaScriptActions", element, XPathConstants.NODE);
        if (this.isElement(javaScriptActionsNode)) {
            Element javaScriptActionsElement = (Element)javaScriptActionsNode;
            javaScriptActions.setAttach(this.getAttribute(javaScriptActionsElement, "attachPZ"));
            javaScriptActions.setBoxReady(this.getAttribute(javaScriptActionsElement, "beforerender"));
            javaScriptActions.setDeselect(this.getAttribute(javaScriptActionsElement, "deselectPZ"));
            javaScriptActions.setDetach(this.getAttribute(javaScriptActionsElement, "detachPZ"));
            javaScriptActions.setSelect(this.getAttribute(javaScriptActionsElement, "selectPZ"));
        }
        return javaScriptActions;
    }

    private Search unmarshallSearch(Element element) throws XPathExpressionException {
        Search search = new Search();
        Node searchNode = (Node)XPATH.evaluate("Search", element, XPathConstants.NODE);
        if (this.isElement(searchNode)) {
            Element searchElement = (Element)searchNode;
            search.setCustomClass(this.getAttribute(searchElement, "class"));
            search.setWhereClauseClass(this.getAttribute(searchElement, "whereClauseClass"));
            Node locationNode = (Node)XPATH.evaluate("Location", searchElement, XPathConstants.NODE);
            if (this.isElement(locationNode)) {
                Element locationElement = (Element)locationNode;
                search.setLocation(this.unmarshallSearchLocation(locationElement));
            }
            ArrayList<SearchCriterion> attachedCriteria = new ArrayList<SearchCriterion>();
            ArrayList<SearchCriterion> notAttachedCriteria = new ArrayList<SearchCriterion>();
            NodeList criteriaList = (NodeList)XPATH.evaluate("Criteria", searchElement, XPathConstants.NODESET);
            for (Element criteriaElement : this.convertToElementsList(criteriaList)) {
                Boolean attached = this.getLogical(criteriaElement, "Attached");
                if (BooleanUtils.isTrue((Boolean)attached)) {
                    attachedCriteria.add(this.unmarshallSearchCriterion(criteriaElement));
                    continue;
                }
                notAttachedCriteria.add(this.unmarshallSearchCriterion(criteriaElement));
            }
            search.setAttachedCriteria(attachedCriteria);
            search.setNotAttachedCriteria(notAttachedCriteria);
        }
        return search;
    }

    private SearchLocation unmarshallSearchLocation(Element element) throws XPathExpressionException {
        String notAttachedName = this.unmarshallSearchLocationNotAttachedName(element);
        SearchLocation location = new SearchLocation();
        location.setAttachedName(this.unmarshallSearchLocationAttachedName(element, notAttachedName));
        location.setNotAttachedName(notAttachedName);
        location.setType(this.getText(element, "Type"));
        location.setPrimaryKey(this.unmarshallSearchLocationPrimaryKey(element));
        return location;
    }

    private String unmarshallSearchLocationNotAttachedName(Element element) throws XPathExpressionException {
        return this.unmarshallSearchLocationName(element, "TableName", "Name");
    }

    private String unmarshallSearchLocationAttachedName(Element element, String notAttachedName) throws XPathExpressionException {
        String attachedName = this.unmarshallSearchLocationName(element, "AttachedTableName", "AttachedName");
        if (StringUtils.isNotBlank((CharSequence)attachedName)) {
            return attachedName;
        }
        return notAttachedName;
    }

    private String unmarshallSearchLocationName(Element element, String tableNameNodeName, String nameNodeName) throws XPathExpressionException {
        String tableName = this.getText(element, tableNameNodeName);
        if (StringUtils.isNotBlank((CharSequence)tableName)) {
            return tableName;
        }
        return this.getText(element, nameNodeName);
    }

    private PrimaryKey unmarshallSearchLocationPrimaryKey(Element element) throws XPathExpressionException {
        Node primaryKeyNode = (Node)XPATH.evaluate("PrimaryKey", element, XPathConstants.NODE);
        if (this.isElement(primaryKeyNode)) {
            Element primaryKeyElement = (Element)primaryKeyNode;
            PrimaryKey primaryKey = new PrimaryKey();
            primaryKey.setName(this.getText(primaryKeyElement));
            primaryKey.setType(this.getAttribute(primaryKeyElement, "type"));
            return primaryKey;
        }
        return null;
    }

    private SearchCriterion unmarshallSearchCriterion(Element element) throws XPathExpressionException {
        SearchCriterion criterion = new SearchCriterion();
        criterion.setAllowEmpty(this.getLogical(element, "AllowBlank"));
        criterion.setMapping(this.getText(element, "Mapping"));
        criterion.setOperator(this.getText(element, "Operator"));
        criterion.setRequired(this.unmarshallSearchCriterionRequired(element));
        criterion.setType(this.getText(element, "Type"));
        criterion.setValue(this.getText(element, "Value"));
        return criterion;
    }

    private Boolean unmarshallSearchCriterionRequired(Element element) throws XPathExpressionException {
        String value = this.getText(element, "Required");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return Boolean.parseBoolean(value);
        }
        return XmlConstants.SEARCH_LOCATION_CRITERIA_REQUIRED_DEAFULT_VALUE;
    }

    private Integer unmarshallTableFontSize(Element element) throws XPathExpressionException {
        String value = this.getText(element, "TableFontSize");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return Integer.parseInt(value);
        }
        return XmlConstants.TABLE_FONT_SIZE_DEFAULT_VALUE;
    }

    private String unmarshallEditableColumnBackgroundColor(Element element) throws XPathExpressionException {
        String value = this.getText(element, "EditableColumnBackgroundColor");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return value;
        }
        return "rgba(255, 255, 153, 0.3)";
    }

    private PanelsConfiguration unmarshallPanelsConfiguration(Element element) throws XPathExpressionException {
        PanelsConfiguration panelsConfiguration = new PanelsConfiguration();
        panelsConfiguration.setNotAttachedPageSize(this.getInteger(element, "NotAttachedTabPageSize"));
        panelsConfiguration.setNotAttachedPagingDisabled(this.getLogical(element, "NotAttachedPagingDisabled"));
        panelsConfiguration.setNotAttachedTitle(this.getText(element, "NotAttachedTabTitle"));
        panelsConfiguration.setNotAttachedFiltersType(this.getText(element, "NotAttachedTabFiltersType"));
        panelsConfiguration.setAttachedTitle(this.getText(element, "AttachedTabTitle"));
        panelsConfiguration.setRightTitle(this.getText(element, "RightTabPanel"));
        panelsConfiguration.setRightVisible(this.getLogical(element, "RightTabPanel", "show"));
        panelsConfiguration.setAttachButtonText(this.getText(element, "AttachButtonText"));
        panelsConfiguration.setDetachButtonText(this.getText(element, "DetachButtonText"));
        panelsConfiguration.setDetachAllButtonText(this.getText(element, "DetachAllButtonText"));
        panelsConfiguration.setSaveButtonText(this.getText(element, "SaveButtonText"));
        panelsConfiguration.setCloseButtonText(this.getText(element, "CloseButtonText"));
        panelsConfiguration.setSelectionButtonsInMenu(this.getLogical(element, "SelectionButtonsInMenu"));
        panelsConfiguration.setToggleGroupsButtonEnabled(this.getLogical(element, "ToggleGroupsButtonEnabled"));
        panelsConfiguration.setDocumentFilters(this.unmarshallDocumentFilters(element));
        return panelsConfiguration;
    }

    private List<DocumentFilter> unmarshallDocumentFilters(Element element) throws XPathExpressionException {
        ArrayList<DocumentFilter> documentFilters = new ArrayList<DocumentFilter>();
        NodeList documentFiltersList = (NodeList)XPATH.evaluate("DocumentFilters/DocumentFilter", element, XPathConstants.NODESET);
        for (Element documentFilterElement : this.convertToElementsList(documentFiltersList)) {
            documentFilters.add(this.unmarshallDocumentFilter(documentFilterElement));
        }
        return documentFilters;
    }

    private DocumentFilter unmarshallDocumentFilter(Element element) throws XPathExpressionException {
        DocumentFilter documentFilter = new DocumentFilter();
        documentFilter.setType(this.getText(element, "Type"));
        documentFilter.setValue(this.getText(element, "Value"));
        return documentFilter;
    }

    private List<Column> convertColumnsToAttached(List<Column> columns, List<String> editableColumnIds) {
        ArrayList<Column> attached = new ArrayList<Column>();
        if (CollectionUtils.isNotEmpty(columns)) {
            for (Column column : columns) {
                Column copy = new Column(column);
                copy.setHidden(column.getHiddenInAttached());
                copy.setEditable(this.isEditableColumn(copy, editableColumnIds));
                attached.add(copy);
            }
        }
        return attached;
    }

    private boolean isEditableColumn(Column column, List<String> editableColumnIds) {
        return editableColumnIds.contains(column.getColumnId());
    }

    private GroupingConfiguration unmarshallGroupingConfiguration(Element element) throws XPathExpressionException {
        GroupingConfiguration groupingConfiguration = new GroupingConfiguration();
        groupingConfiguration.setAttachedStartCollapsed(this.getLogical(element, "Columns/GroupAttachedBy", "startCollapsed"));
        groupingConfiguration.setAttachedMenuEnabled(this.getLogical(element, "Columns/GroupAttachedBy", "enableMenu"));
        groupingConfiguration.setNotAttachedStartCollapsed(this.getLogical(element, "Columns/GroupNotAttachedBy", "startCollapsed"));
        groupingConfiguration.setNotAttachedMenuEnabled(this.getLogical(element, "Columns/GroupNotAttachedBy", "enableMenu"));
        groupingConfiguration.setAttachedGroupers(this.unmarshallAttachedGroupers(element));
        groupingConfiguration.setNotAttachedGroupers(this.unmarshallNotAttachedGroupers(element));
        groupingConfiguration.setAttachedGroupSums(this.unmarshallAttachedGroupSums(element));
        groupingConfiguration.setNotAttachedGroupSums(this.unmarshallNotAttachedGroupSums(element));
        return groupingConfiguration;
    }

    private List<Grouper> unmarshallAttachedGroupers(Element element) throws XPathExpressionException {
        return this.unmarshallGroupers(element, "Columns/GroupAttachedBy");
    }

    private List<Grouper> unmarshallNotAttachedGroupers(Element element) throws XPathExpressionException {
        return this.unmarshallGroupers(element, "Columns/GroupNotAttachedBy");
    }

    private List<Grouper> unmarshallGroupers(Element element, String expression) throws XPathExpressionException {
        Element grouperElement;
        ArrayList<Grouper> groupers = new ArrayList<Grouper>();
        Node grouperNode = (Node)XPATH.evaluate(expression, element, XPathConstants.NODE);
        if (this.isElement(grouperNode) && this.shouldUnmarshallGrouper(grouperElement = (Element)grouperNode)) {
            groupers.add(this.unmarshallGrouper(grouperElement));
        }
        return groupers;
    }

    private boolean shouldUnmarshallGrouper(Element element) {
        String value = this.getText(element);
        return StringUtils.isNotBlank((CharSequence)value);
    }

    private Grouper unmarshallGrouper(Element element) {
        Grouper grouper = new Grouper();
        grouper.setColumnId(this.getText(element));
        grouper.setDirection(this.getAttribute(element, "direction"));
        return grouper;
    }

    private List<GroupSum> unmarshallAttachedGroupSums(Element element) throws XPathExpressionException {
        return this.unmarshallGroupSums(element, "Columns/GroupAttachedBy");
    }

    private List<GroupSum> unmarshallNotAttachedGroupSums(Element element) throws XPathExpressionException {
        return this.unmarshallGroupSums(element, "Columns/GroupNotAttachedBy");
    }

    private List<GroupSum> unmarshallGroupSums(Element element, String expression) throws XPathExpressionException {
        ArrayList<GroupSum> groupSums = new ArrayList<GroupSum>();
        String sumColumns = this.getText(element, expression, "sumColumns");
        if (StringUtils.isNotBlank((CharSequence)sumColumns)) {
            for (String sumColumn : StringUtils.split((String)sumColumns, (String)",")) {
                groupSums.add(this.unmarshallGroupSum(sumColumn));
            }
        }
        return groupSums;
    }

    private GroupSum unmarshallGroupSum(String sumColumn) {
        GroupSum groupSum = new GroupSum();
        groupSum.setColumnId(sumColumn);
        return groupSum;
    }

    private List<Sorter> unmarshallAttachedSorters(Element element) throws XPathExpressionException {
        return this.unmarshallSorters(element, "Columns/SortAttachedBy");
    }

    private List<Sorter> unmarshallNotAttachedSorters(Element element) throws XPathExpressionException {
        return this.unmarshallSorters(element, "Columns/SortNotAttachedBy");
    }

    private List<Sorter> unmarshallSorters(Element element, String expression) throws XPathExpressionException {
        Element sorterElement;
        ArrayList<Sorter> sorters = new ArrayList<Sorter>();
        Node sorterNode = (Node)XPATH.evaluate(expression, element, XPathConstants.NODE);
        if (this.isElement(sorterNode) && this.shouldUnmarshallSorter(sorterElement = (Element)sorterNode)) {
            sorters.add(this.unmarshallSorter(sorterElement));
        }
        return sorters;
    }

    private boolean shouldUnmarshallSorter(Element element) {
        String value = this.getText(element);
        return StringUtils.isNotBlank((CharSequence)value);
    }

    private Sorter unmarshallSorter(Element element) {
        Sorter sorter = new Sorter();
        sorter.setColumnId(this.getText(element));
        sorter.setDirection(this.getAttribute(element, "direction"));
        return sorter;
    }

    private Boolean unmarshallAttachmentWindow(Element element) throws XPathExpressionException {
        return this.getLogical(element, "Attaching", "window");
    }

    private Boolean unmarshallNewWindowDocumentPreview(Element element) throws XPathExpressionException {
        return this.getLogical(element, "NewWindowDocumentPreview");
    }

    private String unmarshallDecimalSeparator(Element element) throws XPathExpressionException {
        return this.getText(element, "DecimalSeparator");
    }

    private Boolean unmarshallLiveFiltering(Element element) throws XPathExpressionException {
        String value = this.getText(element, "LiveFiltering");
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return Boolean.parseBoolean(value);
        }
        return XmlConstants.LIVE_FILTERING_DEAFULT_VALUE;
    }

    private Boolean unmarshallEnableDuplicateChoice(Element element) throws XPathExpressionException {
        return this.getLogical(element, "EnableDuplicateChoice");
    }

    private List<Button> unmarshallButtons(Element element) throws XPathExpressionException {
        ArrayList<Button> buttons = new ArrayList<Button>();
        NodeList buttonsList = (NodeList)XPATH.evaluate("Buttons/Button", element, XPathConstants.NODESET);
        for (Element buttonElement : this.convertToElementsList(buttonsList)) {
            buttons.add(this.unmarshallButton(buttonElement));
        }
        return buttons;
    }

    private Button unmarshallButton(Element element) throws XPathExpressionException {
        Button button = new Button();
        button.setLocation(this.getText(element, "Location"));
        button.setName(this.getText(element, "Name"));
        button.setAction(this.getText(element, "Action"));
        return button;
    }

    private List<ToolbarField> unmarshallToolbarFields(Element element) throws XPathExpressionException {
        ArrayList<ToolbarField> toolbarFields = new ArrayList<ToolbarField>();
        NodeList toolbarFieldsList = (NodeList)XPATH.evaluate("ToolbarFields/ToolbarField", element, XPathConstants.NODESET);
        for (Element toolbarFieldElement : this.convertToElementsList(toolbarFieldsList)) {
            toolbarFields.add(this.unmarshallToolbarField(toolbarFieldElement));
        }
        return toolbarFields;
    }

    private ToolbarField unmarshallToolbarField(Element element) throws XPathExpressionException {
        ToolbarField toolbarField = new ToolbarField();
        toolbarField.setLocation(this.getText(element, "Location"));
        toolbarField.setFieldId(this.getText(element, "Id"));
        toolbarField.setLabel(this.getText(element, "Label"));
        toolbarField.setOperation(this.getText(element, "Operation"));
        toolbarField.setColumnId(this.getText(element, "ColumnId"));
        toolbarField.setVariableId(this.getText(element, "VariableId"));
        toolbarField.setWidth(this.getInteger(element, "Width"));
        return toolbarField;
    }

    private List<FilterRelation> unmarshallFilterRelations(Element element) throws XPathExpressionException {
        ArrayList<FilterRelation> filterRelations = new ArrayList<FilterRelation>();
        NodeList filterRelationsList = (NodeList)XPATH.evaluate("FilterRelations/FilterRelation", element, XPathConstants.NODESET);
        for (Element filterRelationElement : this.convertToElementsList(filterRelationsList)) {
            filterRelations.add(this.unmarshallFilerRelations(filterRelationElement));
        }
        return filterRelations;
    }

    private FilterRelation unmarshallFilerRelations(Element element) throws XPathExpressionException {
        FilterRelation filterRelation = new FilterRelation();
        filterRelation.setRelatedFilters(this.unmarshallRelatedFilters(element));
        return filterRelation;
    }

    private List<RelatedFilter> unmarshallRelatedFilters(Element element) throws XPathExpressionException {
        ArrayList<RelatedFilter> relatedFilters = new ArrayList<RelatedFilter>();
        NodeList relatedFiltersList = (NodeList)XPATH.evaluate("RelatedFilter", element, XPathConstants.NODESET);
        for (Element relatedFilterElement : this.convertToElementsList(relatedFiltersList)) {
            relatedFilters.add(this.unmarshallRelatedFilter(relatedFilterElement));
        }
        return relatedFilters;
    }

    private RelatedFilter unmarshallRelatedFilter(Element element) throws XPathExpressionException {
        RelatedFilter relatedFilter = new RelatedFilter();
        relatedFilter.setFilterId(this.getText(element, "Id"));
        return relatedFilter;
    }

    private PartialAttachmentConfiguration unmarshallPartialAttachmentConfiguration(Element element) throws XPathExpressionException {
        PartialAttachmentConfiguration partialAttachmentConfiguration = new PartialAttachmentConfiguration();
        Node partialAttachmentNode = (Node)XPATH.evaluate("PartialAttachment", element, XPathConstants.NODE);
        if (this.isElement(partialAttachmentNode)) {
            Element partialAttachmentElement = (Element)partialAttachmentNode;
            partialAttachmentConfiguration.setAmountColumnId(this.getText(partialAttachmentElement));
            partialAttachmentConfiguration.setShowMySeparated(this.unmarshallPartialAttachmentConfigurationShowMySeparated(partialAttachmentElement));
            partialAttachmentConfiguration.setValidate(this.unmarshallPartialAttachmentConfigurationValidate(partialAttachmentElement));
            partialAttachmentConfiguration.setAllowNegative(this.unmarshallPartialAttachmentConfigurationAllowNegative(partialAttachmentElement));
            partialAttachmentConfiguration.setShowNegative(this.unmarshallPartialAttachmentConfigurationShowNegative(partialAttachmentElement));
            partialAttachmentConfiguration.setControlSubflows(this.unmarshallPartialAttachmentConfigurationControlSubflows(partialAttachmentElement));
        }
        return partialAttachmentConfiguration;
    }

    private Boolean unmarshallPartialAttachmentConfigurationShowMySeparated(Element element) {
        String value = this.getAttribute(element, "showMySeparated");
        return Boolean.parseBoolean(value);
    }

    private Boolean unmarshallPartialAttachmentConfigurationValidate(Element element) {
        String value = this.getAttribute(element, "validate");
        return Boolean.parseBoolean(value);
    }

    private Boolean unmarshallPartialAttachmentConfigurationAllowNegative(Element element) {
        String value = this.getAttribute(element, "allowNegative");
        return Boolean.parseBoolean(value);
    }

    private Boolean unmarshallPartialAttachmentConfigurationShowNegative(Element element) {
        String value = this.getAttribute(element, "showNegative");
        return Boolean.parseBoolean(value);
    }

    private Boolean unmarshallPartialAttachmentConfigurationControlSubflows(Element element) {
        String value = this.getAttribute(element, "controlSubflows");
        return Boolean.parseBoolean(value);
    }

    private Save unmarshallSave(Element element) throws XPathExpressionException {
        Save save = new Save();
        Node saveNode = (Node)XPATH.evaluate("Save", element, XPathConstants.NODE);
        if (this.isElement(saveNode)) {
            Element saveElement = (Element)saveNode;
            save.setAskBeforeClose(this.unmarshallSaveAskBeforeClose(saveElement));
            save.setAskBeforeSave(this.unmarshallSaveAskBeforeSave(saveElement));
            save.setCustomClass(this.getAttribute(saveElement, "class"));
            save.setActions(this.unmarshallSaveActions(saveElement));
        }
        return save;
    }

    private Boolean unmarshallSaveAskBeforeClose(Element element) {
        String value = this.getAttribute(element, "askBeforeClose");
        return Boolean.parseBoolean(value);
    }

    private Boolean unmarshallSaveAskBeforeSave(Element element) {
        String value = this.getAttribute(element, "askBeforeSave");
        return Boolean.parseBoolean(value);
    }

    private List<SaveAction> unmarshallSaveActions(Element element) throws XPathExpressionException {
        ArrayList<SaveAction> actions = new ArrayList<SaveAction>();
        NodeList actionsList = (NodeList)XPATH.evaluate("SaveIndexesAction|UpdateTableAction|SaveVariablesAction|AttachToProcessAction|CreateSummaryAction", element, XPathConstants.NODESET);
        for (Element actionElement : this.convertToElementsList(actionsList)) {
            if (!this.shouldUnmarshallSaveAction(actionElement)) continue;
            actions.add(this.unmarshallSaveAction(actionElement));
        }
        return actions;
    }

    private boolean shouldUnmarshallSaveAction(Element element) {
        String value = this.getAttribute(element, "active");
        return Boolean.parseBoolean(value);
    }

    private SaveAction unmarshallSaveAction(Element element) throws XPathExpressionException {
        SaveAction action = new SaveAction();
        action.setType(this.unmarshallSaveActionType(element));
        action.setDescription(this.getAttribute(element, "description"));
        action.setDocumentClassName(this.getAttribute(element, "docClassName"));
        action.setHorizontalOrientation(this.unmarshallSaveActionHorizontalOrientation(element));
        action.setSortOrder(this.getAttribute(element, "sortOrder"));
        action.setUpdate(this.unmarshallSaveActionUpdate(element));
        action.setTemplateName(this.getAttribute(element, "templateName"));
        action.setUserName(this.getAttribute(element, "userName"));
        action.setParameters(this.unmarshallSaveActionParameters(element));
        return action;
    }

    private String unmarshallSaveActionType(Element element) {
        String value = this.getName(element);
        value = StringUtils.lowerCase((String)value);
        return StringUtils.removeEnd((String)value, (String)"action");
    }

    private Boolean unmarshallSaveActionHorizontalOrientation(Element element) {
        String value = this.getAttribute(element, "horizontalOrientation");
        return Boolean.parseBoolean(value);
    }

    private Boolean unmarshallSaveActionUpdate(Element element) {
        String value = this.getAttribute(element, "update");
        return Boolean.parseBoolean(value);
    }

    private List<SaveActionParameter> unmarshallSaveActionParameters(Element element) throws XPathExpressionException {
        ArrayList<SaveActionParameter> parameters = new ArrayList<SaveActionParameter>();
        NodeList parametersList = (NodeList)XPATH.evaluate("Variable", element, XPathConstants.NODESET);
        for (Element parameterElement : this.convertToElementsList(parametersList)) {
            parameters.add(this.unmarshallSaveActionParameter(parameterElement));
        }
        return parameters;
    }

    private SaveActionParameter unmarshallSaveActionParameter(Element element) {
        SaveActionParameter parameter = new SaveActionParameter();
        parameter.setType(this.getAttribute(element, "type"));
        parameter.setOperation(this.getAttribute(element, "operation"));
        parameter.setFromValue(this.getAttribute(element, "from"));
        parameter.setToValue(this.getAttribute(element, "to"));
        return parameter;
    }

    private List<Element> convertToElementsList(NodeList nodeList) {
        ArrayList<Element> elements = new ArrayList<Element>();
        if (this.hasElements(nodeList)) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!this.isElement(node)) continue;
                Element element = (Element)node;
                elements.add(element);
            }
        }
        return elements;
    }

    private boolean hasElements(NodeList nodeList) {
        return nodeList != null && nodeList.getLength() > 0;
    }

    private boolean isElement(Node node) {
        return node != null && node instanceof Element;
    }

    private String getAttribute(Element element, String attributeName) {
        return element.getAttribute(attributeName);
    }

    private String getText(Element element) {
        return element.getTextContent();
    }

    private String getText(Element element, String nodeName) throws XPathExpressionException {
        return (String)XPATH.evaluate(nodeName, element, XPathConstants.STRING);
    }

    private String getText(Element element, String nodeName, String attributeName) throws XPathExpressionException {
        Node node = (Node)XPATH.evaluate(nodeName, element, XPathConstants.NODE);
        if (this.isElement(node)) {
            Element nodeElement = (Element)node;
            return this.getAttribute(nodeElement, attributeName);
        }
        return null;
    }

    private Boolean getLogical(Element element, String nodeName) throws XPathExpressionException {
        String text = this.getText(element, nodeName);
        return Boolean.parseBoolean(text);
    }

    private Boolean getLogical(Element element, String nodeName, String attributeName) throws XPathExpressionException {
        String text = this.getText(element, nodeName, attributeName);
        return Boolean.parseBoolean(text);
    }

    private Integer getInteger(Element element, String nodeName) throws XPathExpressionException {
        Double value = (Double)XPATH.evaluate(nodeName, element, XPathConstants.NUMBER);
        if (value != null) {
            return value.intValue();
        }
        return null;
    }

    private String getName(Element element) {
        return element.getNodeName();
    }
}

