/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordsaver;

import com.suncode.plugin.pzmodule.api.dto.configuration.SaveActionDto;
import com.suncode.plugin.pzmodule.api.info.SaveInfo;
import com.suncode.plugin.pzmodule.resolver.recordsaver.SummaryUserNameResolver;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.enhydra.shark.Shark;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.AdminMisc;
import org.springframework.stereotype.Component;

@Component
public class SummaryUserNameResolverImpl
implements SummaryUserNameResolver {
    private static final String TASK_USERNAME = "staskusername";

    @Override
    public String resolve(SharkTransaction sharkTransaction, SaveActionDto saveAction, SaveInfo saveInfo, Map<String, Object> processContext) throws BaseException {
        String summaryUserName = saveAction.getUserName();
        if (StringUtils.isBlank((CharSequence)summaryUserName)) {
            return Shark.getInstance().getProperties().getProperty("SchedulerToolAgent.sharkUsername").replaceAll("[\"]", "");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)summaryUserName, (CharSequence)TASK_USERNAME)) {
            AdminMisc adminMisc = Shark.getInstance().getAdminInterface().getAdminMisc();
            return adminMisc.getActivityResourceUsername(sharkTransaction, saveInfo.getProcessId(), saveInfo.getActivityId());
        }
        Object value = processContext.get(summaryUserName);
        if (value != null) {
            summaryUserName = value.toString();
        }
        if (StringUtils.isBlank((CharSequence)summaryUserName)) {
            return Shark.getInstance().getProperties().getProperty("SchedulerToolAgent.sharkUsername").replaceAll("[\"]", "");
        }
        return summaryUserName;
    }
}

