/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordsaver;

import com.suncode.plugin.pzmodule.api.dto.configuration.SaveActionDto;
import com.suncode.plugin.pzmodule.api.enumeration.SaveActionType;
import com.suncode.plugin.pzmodule.executor.save.record.SaveActionExecutor;
import com.suncode.plugin.pzmodule.resolver.recordsaver.SaveActionExecutorResolver;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class SaveActionExecutorResolverImpl
implements SaveActionExecutorResolver {
    private static final Logger LOG = Logger.getLogger(SaveActionExecutorResolverImpl.class);
    @Autowired
    @Qualifier(value="saveIndexesSaveActionExecutor")
    private SaveActionExecutor saveIndexesSaveActionExecutor;
    @Autowired
    @Qualifier(value="updateTableSaveActionExecutor")
    private SaveActionExecutor updateTableSaveActionExecutor;
    @Autowired
    @Qualifier(value="saveVariablesSaveActionExecutor")
    private SaveActionExecutor saveVariablesSaveActionExecutor;
    @Autowired
    @Qualifier(value="attachToProcessSaveActionExecutor")
    private SaveActionExecutor attachToProcessSaveActionExecutor;
    @Autowired
    @Qualifier(value="summarySaveActionExecutor")
    private SaveActionExecutor summarySaveActionExecutor;
    @Autowired
    @Qualifier(value="partialAttachmentSaveActionExecutor")
    private SaveActionExecutor partialAttachmentSaveActionExecutor;
    @Autowired
    @Qualifier(value="usedSaveActionExecutor")
    private SaveActionExecutor usedSaveActionExecutor;

    @Override
    public SaveActionExecutor resolve(SaveActionDto saveAction) {
        switch (SaveActionType.getByName(saveAction.getType())) {
            case SAVE_INDEXES: {
                return this.saveIndexesSaveActionExecutor;
            }
            case UPDATE_TABLE: {
                return this.updateTableSaveActionExecutor;
            }
            case SAVE_VARIABLES: {
                return this.saveVariablesSaveActionExecutor;
            }
            case ATTACH_TO_PROCESS: {
                return this.attachToProcessSaveActionExecutor;
            }
            case SUMMARY: {
                return this.summarySaveActionExecutor;
            }
            case PARTIAL_ATTACHMENT: {
                return this.partialAttachmentSaveActionExecutor;
            }
            case USED: {
                return this.usedSaveActionExecutor;
            }
        }
        LOG.error((Object)("Nieznana akcja zapisu: " + saveAction.getType()));
        return null;
    }
}

