/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordprovider;

import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.enumeration.ColumnType;
import com.suncode.plugin.pzmodule.api.info.SearchInfo;
import com.suncode.plugin.pzmodule.api.info.support.ParentValues;
import com.suncode.plugin.pzmodule.api.translation.ColumnTranslation;
import com.suncode.plugin.pzmodule.resolver.parentvalue.ParentValueResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.UsedQueryPartResolver;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UsedQueryPartResolverImpl
implements UsedQueryPartResolver {
    @Autowired
    private ParentValueResolver parentValueResolver;

    @Override
    public String resolve(ConfigurationDto configuration, SearchInfo searchInfo, String tableName, Map<String, ColumnType> columnTypes, ColumnTranslation columnTranslation) {
        String primaryKeyName = configuration.getSearch().getLocation().getPrimaryKey().getName();
        ColumnType columnType = columnTypes.get(primaryKeyName);
        ParentValues parentValues = searchInfo.getParentValues();
        StringBuilder part = new StringBuilder();
        part.append("NOT EXISTS (SELECT 1 FROM ");
        part.append("pm_pzmodule_partial_att");
        part.append(" WHERE ");
        part.append("configuration_id='");
        part.append(this.parentValueResolver.resolveConfigurationId(configuration, parentValues));
        part.append("' AND process_id!='");
        part.append(this.parentValueResolver.resolveProcessId(configuration, searchInfo.getProcessId(), parentValues));
        part.append("' AND ");
        part.append(tableName);
        part.append(".");
        part.append(primaryKeyName);
        part.append("=");
        part.append(columnType.getPartialAttachmentValueColumn());
        part.append(")");
        return part.toString();
    }
}

