/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordprovider;

import com.suncode.plugin.pzmodule.api.dto.configuration.FilterRelationDto;
import com.suncode.plugin.pzmodule.api.info.support.Filter;
import com.suncode.plugin.pzmodule.api.info.support.SubGroupsFilter;
import com.suncode.plugin.pzmodule.api.translation.ColumnTranslation;
import com.suncode.plugin.pzmodule.resolver.recordprovider.FilterQueryPartResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.SubGroupsFilterQueryPartResolver;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SubGroupsFilterQueryPartResolverImpl
implements SubGroupsFilterQueryPartResolver {
    private static final String GROUPING_FIELD_ALIAS = "GROUPING_FIELD";
    private static final String SUBQUERY_ALIAS = "GROUPPED";
    @Autowired
    private FilterQueryPartResolver filterQueryPartResolver;

    @Override
    public String resolve(SubGroupsFilter filter, String tableName, List<String> conditions, List<FilterRelationDto> filterRelations, Map<String, String> dateStringInputFormats, ColumnTranslation columnTranslation) {
        String groupingFieldColumnId = columnTranslation.getTranslation(filter.getGroupingField());
        List<Filter> filters = this.supplyFilters(filter.getFilters(), columnTranslation);
        List<String> havingConditions = this.filterQueryPartResolver.resolve(filters, filterRelations, dateStringInputFormats, columnTranslation);
        StringBuilder part = new StringBuilder();
        part.append("JOIN (SELECT ");
        part.append(groupingFieldColumnId);
        part.append(" AS ");
        part.append(GROUPING_FIELD_ALIAS);
        part.append(" FROM ");
        part.append(tableName);
        part.append(this.resolveConditions(conditions, "WHERE"));
        part.append(" GROUP BY ");
        part.append(groupingFieldColumnId);
        part.append(this.resolveConditions(havingConditions, "HAVING"));
        part.append(") ");
        part.append(SUBQUERY_ALIAS);
        part.append(" ON ");
        part.append(tableName);
        part.append(".");
        part.append(groupingFieldColumnId);
        part.append("=");
        part.append(SUBQUERY_ALIAS);
        part.append(".");
        part.append(GROUPING_FIELD_ALIAS);
        return part.toString();
    }

    private List<Filter> supplyFilters(List<Filter> filters, ColumnTranslation columnTranslation) {
        if (CollectionUtils.isNotEmpty(filters)) {
            for (Filter filter : filters) {
                filter.setField(this.supplyFilterField(filter, columnTranslation));
            }
        }
        return filters;
    }

    private String supplyFilterField(Filter filter, ColumnTranslation columnTranslation) {
        StringBuilder field = new StringBuilder();
        field.append("SUM(");
        field.append(columnTranslation.getTranslation(filter.getField()));
        field.append(")");
        return field.toString();
    }

    private String resolveConditions(List<String> conditions, String conditionStart) {
        StringBuilder subPart = new StringBuilder();
        if (CollectionUtils.isNotEmpty(conditions)) {
            String joinedConditions = StringUtils.join(conditions, (String)" AND ");
            subPart.append(" ");
            subPart.append(conditionStart);
            subPart.append(" ");
            subPart.append(joinedConditions);
        }
        return subPart.toString();
    }
}

