/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordprovider;

import com.suncode.plugin.pzmodule.api.dto.configuration.ColumnDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SaveActionDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SaveActionParameterDto;
import com.suncode.plugin.pzmodule.api.enumeration.SaveActionParameterOperation;
import com.suncode.plugin.pzmodule.api.enumeration.SaveActionParameterType;
import com.suncode.plugin.pzmodule.api.enumeration.SaveActionType;
import com.suncode.plugin.pzmodule.resolver.recordprovider.BindedColumn;
import com.suncode.plugin.pzmodule.resolver.recordprovider.Binding;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class BindingResolver {
    public Binding resolve(boolean attached, ConfigurationDto configuration) {
        List<SaveActionDto> saveVariablesActions;
        Binding binding = new Binding();
        if (attached && !(saveVariablesActions = BindingResolver.resolveSaveVariablesAction(configuration)).isEmpty()) {
            List<String> editableColumnDataIndexes = BindingResolver.resolveEditableColumnDataIndexes(configuration);
            String primaryKeyName = configuration.getSearch().getLocation().getPrimaryKey().getName();
            binding.setBindedColumns(BindingResolver.resolveBindedColumns(saveVariablesActions, editableColumnDataIndexes));
            binding.setPrimaryKeyVariableId(BindingResolver.resolvePrimaryKeyVariableId(saveVariablesActions, primaryKeyName));
        }
        return binding;
    }

    private static List<String> resolveEditableColumnDataIndexes(ConfigurationDto configuration) {
        return configuration.getAttachedColumns().stream().filter(BindingResolver::isEditableColumn).map(ColumnDto::getDataIndex).collect(Collectors.toList());
    }

    private static boolean isEditableColumn(ColumnDto column) {
        return BooleanUtils.isTrue((Boolean)column.getEditable());
    }

    private static List<SaveActionDto> resolveSaveVariablesAction(ConfigurationDto configuration) {
        return configuration.getSave().getActions().stream().filter(BindingResolver::isSaveVariablesAction).collect(Collectors.toList());
    }

    private static boolean isSaveVariablesAction(SaveActionDto saveAction) {
        return SaveActionType.getByName(saveAction.getType()) == SaveActionType.SAVE_VARIABLES;
    }

    private static List<BindedColumn> resolveBindedColumns(List<SaveActionDto> saveVariablesActions, List<String> editableColumnDataIndexes) {
        return saveVariablesActions.stream().map(SaveActionDto::getParameters).flatMap(Collection::stream).filter(parameter -> BindingResolver.isBindedColumn(parameter, editableColumnDataIndexes)).map(BindingResolver::mapToBindedColumn).collect(Collectors.toList());
    }

    private static boolean isBindedColumn(SaveActionParameterDto parameter, List<String> editableColumnDataIndexes) {
        return SaveActionParameterOperation.getByName(parameter.getOperation()) == SaveActionParameterOperation.VALUE && editableColumnDataIndexes.contains(parameter.getFromValue());
    }

    private static BindedColumn mapToBindedColumn(SaveActionParameterDto parameter) {
        return new BindedColumn(BindingResolver.isInDt(parameter), parameter.getFromValue(), parameter.getToValue());
    }

    private static boolean isInDt(SaveActionParameterDto parameter) {
        return SaveActionParameterType.getByName(parameter.getType()) == SaveActionParameterType.DT;
    }

    private static String resolvePrimaryKeyVariableId(List<SaveActionDto> saveVariablesActions, String primaryKeyName) {
        return saveVariablesActions.stream().map(SaveActionDto::getParameters).flatMap(Collection::stream).filter(parameter -> BindingResolver.isPrimaryKey(parameter, primaryKeyName)).map(SaveActionParameterDto::getToValue).findFirst().orElse(null);
    }

    private static boolean isPrimaryKey(SaveActionParameterDto parameter, String primaryKeyName) {
        return StringUtils.equals((CharSequence)parameter.getFromValue(), (CharSequence)primaryKeyName);
    }
}

