/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.recordprovider;

import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.PartialAttachmentConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.PrimaryKeyDto;
import com.suncode.plugin.pzmodule.api.enumeration.ColumnType;
import com.suncode.plugin.pzmodule.api.enumeration.PrimaryKeyType;
import com.suncode.plugin.pzmodule.api.info.SearchInfo;
import com.suncode.plugin.pzmodule.api.translation.ColumnTranslation;
import com.suncode.plugin.pzmodule.api.util.QueryUtils;
import com.suncode.plugin.pzmodule.resolver.recordprovider.AttachedQueryPartResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.PartialAttachmentConditionPartResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.PartialAttachmentSubqueryResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AttachedQueryPartResolverImpl
implements AttachedQueryPartResolver {
    @Autowired
    private PartialAttachmentSubqueryResolver partialAttachmentSubqueryResolver;
    @Autowired
    private PartialAttachmentConditionPartResolver partialAttachmentConditionPartResolver;

    @Override
    public List<String> resolve(ConfigurationDto configuration, List<String> attachedIds, SearchInfo searchInfo, String tableName, Map<String, ColumnType> columnTypes, ColumnTranslation columnTranslation) {
        ArrayList<String> parts = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(attachedIds)) {
            Map<String, Double> amounts = searchInfo.getAmounts();
            PrimaryKeyDto primaryKey = configuration.getSearch().getLocation().getPrimaryKey();
            String primaryKeyName = primaryKey.getName();
            PrimaryKeyType primaryKeyType = PrimaryKeyType.getByName(primaryKey.getType());
            String partialAmountSumSelect = this.resolvePartialAmountSumSelect(configuration, searchInfo, tableName, columnTypes);
            for (String attachedId : attachedIds) {
                Double attachedAmount = amounts.get(attachedId);
                String partialAttachmentCondition = this.resolvePartialAttachmentCondition(configuration, partialAmountSumSelect, attachedAmount, columnTranslation);
                parts.add(this.resolve(primaryKeyName, primaryKeyType, attachedId, partialAttachmentCondition));
            }
        }
        return parts;
    }

    private String resolvePartialAmountSumSelect(ConfigurationDto configuration, SearchInfo searchInfo, String tableName, Map<String, ColumnType> columnTypes) {
        if (this.isPartialAttachmentShowMySeparatedActive(configuration)) {
            return this.partialAttachmentSubqueryResolver.resolvePartialAmountSumSelect(configuration, searchInfo.getParentValues(), tableName, columnTypes);
        }
        return "";
    }

    private boolean isPartialAttachmentShowMySeparatedActive(ConfigurationDto configuration) {
        PartialAttachmentConfigurationDto partialAttachmentConfiguration = configuration.getPartialAttachmentConfiguration();
        return StringUtils.isNotBlank((CharSequence)partialAttachmentConfiguration.getAmountColumnId()) && BooleanUtils.isTrue((Boolean)partialAttachmentConfiguration.getShowMySeparated());
    }

    private String resolvePartialAttachmentCondition(ConfigurationDto configuration, String partialAmountSumSelect, Double attachedAmount, ColumnTranslation columnTranslation) {
        if (StringUtils.isNotBlank((CharSequence)partialAmountSumSelect)) {
            StringBuilder condition = new StringBuilder();
            condition.append("((");
            condition.append(this.partialAttachmentConditionPartResolver.resolve(configuration, columnTranslation.getTranslation(configuration.getPartialAttachmentConfiguration().getAmountColumnId())));
            condition.append(" - ");
            if (this.isMeaningfulValue(attachedAmount)) {
                condition.append(this.partialAttachmentConditionPartResolver.resolve(configuration, attachedAmount));
                condition.append(" - ");
            }
            condition.append(this.partialAttachmentConditionPartResolver.resolve(configuration, partialAmountSumSelect));
            condition.append(")");
            if (this.shouldShowNegativeValues(configuration)) {
                condition.append("!=");
            } else {
                condition.append(">");
            }
            condition.append("0");
            condition.append(")");
            return condition.toString();
        }
        return "";
    }

    private boolean isMeaningfulValue(Double value) {
        return value != null && value != 0.0;
    }

    private boolean shouldShowNegativeValues(ConfigurationDto configuration) {
        return BooleanUtils.isTrue((Boolean)configuration.getPartialAttachmentConfiguration().getShowNegative());
    }

    private String resolve(String primaryKeyName, PrimaryKeyType primaryKeyType, String attachedId, String partialAttachmentCondition) {
        StringBuilder subPart = new StringBuilder();
        subPart.append("(");
        subPart.append(primaryKeyName);
        subPart.append("!=");
        subPart.append(primaryKeyType.getConditionSuffix());
        subPart.append(QueryUtils.getSafeValue(attachedId));
        subPart.append(primaryKeyType.getConditionSuffix());
        if (StringUtils.isNotBlank((CharSequence)partialAttachmentCondition)) {
            subPart.append(" OR ");
            subPart.append(partialAttachmentCondition);
        }
        subPart.append(")");
        return subPart.toString();
    }
}

