/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.provider.record;

import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.exception.RecordProviderException;
import com.suncode.plugin.pzmodule.api.info.AttachedInfo;
import com.suncode.plugin.pzmodule.api.info.FilterInfo;
import com.suncode.plugin.pzmodule.api.info.PagingInfo;
import com.suncode.plugin.pzmodule.api.info.SearchInfo;
import com.suncode.plugin.pzmodule.api.info.SortInfo;
import com.suncode.plugin.pzmodule.api.provider.record.RecordProvider;
import com.suncode.plugin.pzmodule.api.record.RecordPage;
import com.suncode.plugin.pzmodule.api.result.GroupSumResult;
import com.suncode.plugin.pzmodule.api.result.SumAllResult;
import com.suncode.plugin.pzmodule.api.translation.ColumnTranslation;
import com.suncode.plugin.pzmodule.provider.record.InternalRecordProvider;
import com.suncode.plugin.pzmodule.resolver.configuration.ConfigurationResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.ColumnTranslationResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.DocumentClassResolver;
import com.suncode.plugin.pzmodule.translation.Translator;
import com.suncode.pwfl.archive.DocumentClass;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="documentClassRecordProvider")
public class DocumentClassRecordProviderImpl
implements RecordProvider {
    private static final Logger LOG = Logger.getLogger(DocumentClassRecordProviderImpl.class);
    private static final String CONFIGURATION_ERROR_MESSAGE = "pzmodule.program.configuration.error";
    @Autowired
    private ConfigurationResolver configurationResolver;
    @Autowired
    private DocumentClassResolver documentClassResolver;
    @Autowired
    private ColumnTranslationResolver columnTranslationResolver;
    @Autowired
    private InternalRecordProvider internalRecordProvider;
    @Autowired
    private Translator translator;

    @Override
    public RecordPage getPage(ConfigurationDto configuration, boolean attached, AttachedInfo attachedInfo, SearchInfo searchInfo, FilterInfo filterInfo, SortInfo sortInfo, PagingInfo pagingInfo) throws RecordProviderException {
        DocumentClass documentClass = this.getDocumentClass(configuration, attached);
        ColumnTranslation columnTranslation = this.columnTranslationResolver.resolve(configuration, attached, documentClass);
        String tableName = this.documentClassResolver.resolveTableName(documentClass);
        return this.internalRecordProvider.getPage(configuration, attached, attachedInfo, searchInfo, filterInfo, sortInfo, pagingInfo, tableName, columnTranslation);
    }

    private DocumentClass getDocumentClass(ConfigurationDto configuration, boolean attached) throws RecordProviderException {
        String documentClassName = this.configurationResolver.resolveSearchLocationName(configuration, attached);
        DocumentClass documentClass = this.documentClassResolver.resolve(documentClassName);
        if (documentClass == null) {
            LOG.error((Object)("Klasa dokumentow o nazwie " + documentClassName + " nie istnieje w systemie"));
            throw new RecordProviderException(this.buildConfigurationErrorMessage());
        }
        return documentClass;
    }

    private String buildConfigurationErrorMessage() {
        return this.translator.translateMessage(CONFIGURATION_ERROR_MESSAGE);
    }

    @Override
    public List<GroupSumResult> sumInGroup(ConfigurationDto configuration, boolean attached, AttachedInfo attachedInfo, SearchInfo searchInfo, FilterInfo filterInfo) throws RecordProviderException {
        DocumentClass documentClass = this.getDocumentClass(configuration, attached);
        ColumnTranslation columnTranslation = this.columnTranslationResolver.resolve(configuration, attached, documentClass);
        String tableName = this.documentClassResolver.resolveTableName(documentClass);
        return this.internalRecordProvider.sumInGroups(configuration, attached, attachedInfo, searchInfo, filterInfo, tableName, columnTranslation);
    }

    @Override
    public SumAllResult sumAll(ConfigurationDto configuration, boolean attached, String columnId, AttachedInfo attachedInfo, SearchInfo searchInfo, FilterInfo filterInfo) throws RecordProviderException {
        DocumentClass documentClass = this.getDocumentClass(configuration, attached);
        ColumnTranslation columnTranslation = this.columnTranslationResolver.resolve(configuration, attached, documentClass);
        String tableName = this.documentClassResolver.resolveTableName(documentClass);
        return this.internalRecordProvider.sumAll(configuration, attached, columnId, attachedInfo, searchInfo, filterInfo, tableName, columnTranslation);
    }
}

