/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.executor.save.record;

import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SaveActionDto;
import com.suncode.plugin.pzmodule.api.enumeration.RecordLocation;
import com.suncode.plugin.pzmodule.api.enumeration.SaveActionParameterType;
import com.suncode.plugin.pzmodule.api.info.SaveInfo;
import com.suncode.plugin.pzmodule.api.record.Record;
import com.suncode.plugin.pzmodule.exception.SaveActionExecutorException;
import com.suncode.plugin.pzmodule.executor.save.record.SaveActionExecutor;
import com.suncode.plugin.pzmodule.resolver.configuration.ConfigurationResolver;
import com.suncode.plugin.pzmodule.resolver.recordprovider.DocumentClassResolver;
import com.suncode.plugin.pzmodule.resolver.recordsaver.IndexesResolver;
import com.suncode.plugin.pzmodule.service.shark.SharkService;
import com.suncode.plugin.pzmodule.translation.Translator;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.FileService;
import com.suncode.pwfl.util.ServiceFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.ConnectFailed;
import org.enhydra.shark.api.client.wfservice.NotConnected;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="saveIndexesSaveActionExecutor")
public class SaveIndexesSaveActionExecutorImpl
implements SaveActionExecutor {
    private static final Logger LOG = Logger.getLogger(SaveIndexesSaveActionExecutorImpl.class);
    private static final String SAVE_ERROR_MESSAGE = "pzmodule.program.save.error";
    @Autowired
    private SharkService sharkService;
    @Autowired
    private ConfigurationResolver configurationResolver;
    @Autowired
    private DocumentClassResolver documentClassResolver;
    @Autowired
    private IndexesResolver indexesResolver;
    @Autowired
    private Translator translator;

    @Override
    public void execute(SharkTransaction sharkTransaction, Session session, ConfigurationDto configuration, SaveActionDto saveAction, SaveInfo saveInfo, List<Record> attachedRecords) throws SaveActionExecutorException {
        if (this.isDocumentClassRecordLocation(configuration)) {
            try {
                Map<String, Object> activityContext = this.getActivityContext(sharkTransaction, saveInfo.getProcessId(), saveInfo.getActivityId());
                List<String> documentClassNames = this.getDocumentClassNames(configuration);
                String primaryKeyName = configuration.getSearch().getLocation().getPrimaryKey().getName();
                this.execute(documentClassNames, saveAction, saveInfo, attachedRecords, activityContext, primaryKeyName);
            }
            catch (SaveActionExecutorException exception) {
                throw exception;
            }
            catch (Exception exception) {
                LOG.error((Object)exception.getMessage(), (Throwable)exception);
                throw new SaveActionExecutorException(this.buildSaveErrorMessage());
            }
        }
    }

    private boolean isDocumentClassRecordLocation(ConfigurationDto configuration) {
        RecordLocation recordLocation = RecordLocation.getByName(configuration.getSearch().getLocation().getType());
        return recordLocation.equals((Object)RecordLocation.DOCUMENT_CLASS);
    }

    private Map<String, Object> getActivityContext(SharkTransaction sharkTransaction, String processId, String activityId) throws BaseException, ConnectFailed, NotConnected {
        return this.sharkService.getActivityContext(sharkTransaction, processId, activityId);
    }

    private List<String> getDocumentClassNames(ConfigurationDto configuration) {
        ArrayList<String> names = new ArrayList<String>();
        String notAttachedName = this.configurationResolver.resolveSearchLocationName(configuration, false);
        String attachedName = this.configurationResolver.resolveSearchLocationName(configuration, false);
        names.add(notAttachedName);
        if (!StringUtils.equals((CharSequence)notAttachedName, (CharSequence)attachedName)) {
            names.add(attachedName);
        }
        return names;
    }

    private void execute(List<String> documentClassNames, SaveActionDto saveAction, SaveInfo saveInfo, List<Record> attachedRecords, Map<String, Object> activityContext, String primaryKeyName) throws SaveActionExecutorException {
        for (String documentClassName : documentClassNames) {
            DocumentClass documentClass = this.documentClassResolver.resolve(documentClassName);
            List<String> attachedFileIds = this.getFileIds(attachedRecords);
            List<String> detachedFileIds = this.getDetachedFileIds(saveInfo, attachedFileIds);
            if (CollectionUtils.isNotEmpty(attachedFileIds)) {
                this.execute(saveAction, saveInfo, attachedRecords, activityContext, documentClass, attachedFileIds, SaveActionParameterType.ATTACH, primaryKeyName);
            }
            if (!CollectionUtils.isNotEmpty(detachedFileIds)) continue;
            this.execute(saveAction, saveInfo, attachedRecords, activityContext, documentClass, detachedFileIds, SaveActionParameterType.DETACH, primaryKeyName);
        }
    }

    private void execute(SaveActionDto saveAction, SaveInfo saveInfo, List<Record> attachedRecords, Map<String, Object> activityContext, DocumentClass documentClass, List<String> fileIds, SaveActionParameterType acceptedParameterType, String primaryKeyName) throws SaveActionExecutorException {
        FileService fileService = ServiceFactory.getFileService();
        for (String fileId : fileIds) {
            Map<Long, Object> indexes = this.indexesResolver.resolve(saveAction, saveInfo, attachedRecords, activityContext, documentClass, acceptedParameterType, primaryKeyName);
            if (!MapUtils.isNotEmpty(indexes)) continue;
            fileService.changeFileIndexes(Long.valueOf(fileId), indexes);
        }
    }

    private List<String> getFileIds(List<Record> records) {
        ArrayList<String> fileIds = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(records)) {
            for (Record record : records) {
                fileIds.add(this.getFileId(record));
            }
        }
        return fileIds;
    }

    private String getFileId(Record record) {
        return record.getValue("fileid");
    }

    private List<String> getDetachedFileIds(SaveInfo saveInfo, List<String> attachedFileIds) {
        List<String> detachedFileIds = this.getFileIds(saveInfo.getInitiallyAttachedRecords());
        if (CollectionUtils.isNotEmpty(attachedFileIds)) {
            for (String attachedFileId : attachedFileIds) {
                detachedFileIds.remove(attachedFileId);
            }
        }
        return detachedFileIds;
    }

    private String buildSaveErrorMessage() {
        return this.translator.translateMessage(SAVE_ERROR_MESSAGE);
    }
}

