/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.evaluator;

import com.suncode.plugin.pzmodule.evaluator.ExpressionEvaluator;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Component
public class ExpressionEvaluatorImpl
implements ExpressionEvaluator {
    private static final String MODIFIED_COLUMN_ID_VARIABLE_NAME = "modifiedColumnId";
    private static final ExpressionParser PARSER = new SpelExpressionParser();

    @Override
    public String evaluate(String expression, String modifiedColumnId) {
        StandardEvaluationContext evaluationContext = this.buildEvaluationContext(modifiedColumnId);
        Expression spEl = PARSER.parseExpression(expression);
        return (String)spEl.getValue((EvaluationContext)evaluationContext, String.class);
    }

    private StandardEvaluationContext buildEvaluationContext(String modifiedColumnId) {
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext();
        evaluationContext.setVariable(MODIFIED_COLUMN_ID_VARIABLE_NAME, (Object)modifiedColumnId);
        return evaluationContext;
    }
}

