(function (Ext) {
  Ext.define('Suncode.pzmodule.view.filter.IntegerPanelFilter', {
    extend: 'Suncode.pzmodule.view.filter.PanelFilter',
    alias: 'gridpanelfilter.int',
    filterType: 'int',
    initComponent: function () {
      this.items = [{
        xtype: 'numberfield',
        fieldLabel: '>=',
        labelSeparator: '',
        labelWidth: 8,
        enableKeyEvents: true,
        allowDecimals: false,
        allowExponential: false,
        hideTrigger: true,
        keyNavEnabled: false,
        mouseWheelEnabled: false,
        comparison: 'gt',
        value: !Ext.isEmpty(this.filtersInit.gt) ? this.filtersInit.gt.initValue
            : null,
        listeners: {
          scope: this,
          keydown: this.onFilterKeyDown,
          keypress: this.onFilterKeyPress
        }
      }, {
        xtype: 'numberfield',
        fieldLabel: '<=',
        labelSeparator: '',
        labelWidth: 8,
        enableKeyEvents: true,
        allowDecimals: false,
        allowExponential: false,
        hideTrigger: true,
        keyNavEnabled: false,
        mouseWheelEnabled: false,
        comparison: 'lt',
        value: !Ext.isEmpty(this.filtersInit.lt) ? this.filtersInit.lt.initValue
            : null,
        listeners: {
          scope: this,
          keydown: this.onFilterKeyDown,
          keypress: this.onFilterKeyPress
        }
      }];

      this.addListener('afterrender', this.onFilterAfterRender, this);

      this.callParent(arguments);
    }
  });
}(this.Ext4));