(function(Ext) {
	Ext.define( 'Suncode.pzmodule.view.filter.DatePanelFilter', {
		extend: 'Suncode.pzmodule.view.filter.PanelFilter',
		alias: 'gridpanelfilter.date',
		filterType: 'date',
		initComponent: function() {
			this.items = [ {
				xtype: 'datefield',
				triggerCls: 'dvnt-icon-calendar',
				fieldLabel: '>=',
				labelSeparator: '',
				labelWidth: 8,
				enableKeyEvents: true,
				format: this.dateFormat,
				comparison: 'gt',
				value: !Ext.isEmpty( this.filtersInit.gt ) ? this.filtersInit.gt.initValue : null,
				listeners: {
					scope: this,
					keydown: this.onFilterKeyDown,
					keypress: this.onFilterKeyPress,
					select: this.onFilterSelectDate
				}
			}, {
				xtype: 'datefield',
				triggerCls: 'dvnt-icon-calendar',
				fieldLabel: '<=',
				labelSeparator: '',
				labelWidth: 8,
				enableKeyEvents: true,
				format: this.dateFormat,
				comparison: 'lt',
				value: !Ext.isEmpty( this.filtersInit.lt ) ? this.filtersInit.lt.initValue : null,
				listeners: {
					scope: this,
					keydown: this.onFilterKeyDown,
					keypress: this.onFilterKeyPress,
					select: this.onFilterSelectDate
				}
			} ];
			
			this.addListener( 'afterrender', this.onFilterAfterRender, this );
			
			this.callParent( arguments );
		},
		onFilterSelectDate: function( field, value, eOpts ) {
			this.filterTask.delay( 0 );
		}
	});
}(this.Ext4));