(function (Ext) {
  Ext.define('Suncode.pzmodule.controller.panel.MainPanelController', {
    extend: 'Ext.app.Controller',
    init: function () {
      this.control({
        'mainpanel': {
          boxready: this.onBoxReady
        }
      });
    },
    onBoxReady: function (panel, width, height, eOpts) {
      this.manageNewWindowDocumentPreviews(panel);
      this.scrollToMainPanel(panel);
      this.callBoxReadyAction(panel);
    },
    manageNewWindowDocumentPreviews: function (panel) {
      if (panel.configuration.newWindowDocumentPreview && !Ext.isEmpty(
          panel.documents)) {
        Ext.each(panel.documents, function (document, index, documents) {
          var src = Suncode.context('pzmodule').contextPath + '/'
              + document.showFileLink;
          window.open(src);
        });
      }
    },
    scrollToMainPanel: function (panel) {
      var pos = panel.getPosition();
      var y = pos[1];
      window.scroll(0, y);
    },
    callBoxReadyAction: function (panel) {
      var boxReadyAction = panel.configuration.javaScriptActions.boxReady;

      if (!Ext.isEmpty(boxReadyAction)) {
        try {
          var handler = this.getActionHandler(boxReadyAction);
          Ext.Function.bind(handler).apply(window, []);
        } catch (exception) {
          this.logException(exception);
        }
      }
    },
    getActionHandler: function (action) {
      var table = action.split('.');
      var handler = window;

      Ext.each(table, function (part, index, parts) {
        handler = handler[part];
      });

      return handler;
    },
    logException: function (exception) {
      if (typeof console !== 'undefined' && Ext.isFunction(console.log)
          && !Ext.isEmpty(exception)) {
        console.log(exception);
      }
    }
  });
}(this.Ext4));