(function (Ext) {
  Ext.define('Suncode.pzmodule.controller.button.ExtraButtonController', {
    extend: 'Ext.app.Controller',
    init: function () {
      this.control({
        'extrabutton': {
          click: this.executeAction
        }
      });
    },
    executeAction: function (button, e, eOpts) {
      try {
        var handler = this.getActionHandler(button.action);
        var selectedRecords = this.getSelectedRecords(button);
        var attachedRecords = this.getAttachedRecords(button);
        Ext.Function.bind(handler).apply(window,
            [selectedRecords, attachedRecords]);
      } catch (exception) {
        this.logException(exception);
      }
    },
    getActionHandler: function (action) {
      var table = action.split('.');
      var handler = window;

      Ext.each(table, function (part, index, parts) {
        handler = handler[part];
      });

      return handler;
    },
    getSelectedRecords: function (button) {
      var table = this.getTable(button, false);
      var selModel = table.getSelectionModel();

      return selModel.getSelection();
    },
    getAttachedRecords: function (button) {
      var table = this.getTable(button, true);
      var store = table.getStore();

      return store.getRange();
    },
    getTable: function (button, attached) {
      var mainPanel = button.up('mainpanel');

      return mainPanel.down('recordtable[attached= ' + attached + ']');
    },
    logException: function (exception) {
      if (typeof console !== 'undefined' && Ext.isFunction(console.log)
          && !Ext.isEmpty(exception)) {
        console.log(exception);
      }
    }
  });
}(this.Ext4));