( function( Ext ) {
    var messages = Suncode.context( 'pzmodule' ).messages;

    Ext.define( 'Suncode.pzmodule.controller.button.ManageConfigurationWindowButtonController', {
        extend: 'Ext.app.Controller',
        init: function() {
        	this.eventbus.unlisten( this.id );
            this.control( {
                'manageconfigurationwindow button[itemId=addConfigurationButton]': {
                    click: this.addConfiguration
                },
                'manageconfigurationwindow button[itemId=editConfigurationButton]': {
                    click: this.editConfiguration
                },
                'manageconfigurationwindow button[itemId=closeWindowButton]': {
                    click: this.closeWindow
                }
            } );
        },
        addConfiguration: function( button, e, eOpts ) {
        	var win = button.up( 'window' );
        	var url = Suncode.context( 'pzmodule' ).pluginContextPath + '/api/administration/configuration/create';
        	var defaultError = messages( 'pzmodule.addconfigurationerror' )
        		
        	this.manageConfiguration( win, url, defaultError );
        },
        editConfiguration: function( button, e, eOpts ) {
        	var win = button.up( 'window' );
        	var idOfConfiguration = win.idOfConfiguration;
        	var url = Suncode.context( 'pzmodule' ).pluginContextPath + '/api/administration/configuration/update/' + idOfConfiguration;
        	var defaultError = messages( 'pzmodule.editconfigurationerror' )
        		
        	this.manageConfiguration( win, url, defaultError );
        },
        manageConfiguration: function( win, url, defaultError ) {
            var form = win.down( 'form' ).getForm();

            if ( form.isValid() ) {
                form.submit( {
                    url: url,
                    timeout: 120,
                    scope: this,
                    success: function( form, action ) {
                        win.close();
                        var table = win.table;
                        table.reload();
                    },
                    failure: function( form, action ) {
                        var errorMessage = !Ext.isEmpty( action.result ) ? action.result.message : '';

                        Ext.Msg.show( {
                            title: messages( 'pzmodule.error' ),
                            msg: !Ext.isEmpty( errorMessage ) ? errorMessage : defaultError,
                            buttons: Ext.Msg.OK,
                            icon: 'dvnt-icon-x-circle dvnt-red-icon'
                        } );
                    }
                } );
            }
        },
        closeWindow: function( button, e, eOpts ) {
            var win = button.up( 'window' );

            if ( !Ext.isEmpty( win ) ) {
            	win.close();
            }
        }
    } );
}( this.Ext4 ) );