( function( Ext ) {
    var messages = Suncode.context( 'pzmodule' ).messages;

    Ext.define( 'Suncode.pzmodule.controller.button.ImportAttachedWindowButtonController', {
        extend: 'Ext.app.Controller',
        init: function() {
        	this.eventbus.unlisten( this.id );
            this.control( {
                'importattachedwindow button[itemId=importAttachedButton]': {
                    click: this.importAttached
                },
                'importattachedwindow button[itemId=downloadTemplateButton]': {
                    click: this.downloadTemplate
                },
                'importattachedwindow button[itemId=closeWindowButton]': {
                    click: this.closeWindow
                }
            } );
        },
        importAttached: function( button, e, eOpts ) {
        	var win = button.up( 'window' );
            
            if ( !Ext.isEmpty( win ) ) {
            	var form = win.down( 'form' ).getForm();
            	
            	if ( form.isValid() ) {
                    form.submit( {
                    	url: Suncode.context( 'pzmodule' ).pluginContextPath + '/api/administration/partialattachment/import',
                        timeout: 600,
                        waitMsg: messages( 'pzmodule.importinprogress' ),
                        success: function( form, action ) {
                        	win.close();
                        },
                        failure: function( form, action ) {
                            Ext.Msg.show( {
                                title: messages( 'pzmodule.error' ),
                                msg: action.result.message,
                                buttons: Ext.Msg.OK,
                                icon: 'dvnt-icon-x-circle dvnt-red-icon'
                            } );
                        }
                    } );
                }
            }
        },
        downloadTemplate: function( button, e, eOpts ) {
        	var win = button.up( 'window' );
        	
        	if ( !Ext.isEmpty( win ) ) {
	        	var form = win.down( 'form' ).getForm();
	
	            form.submit( {
	                clientValidation: false,
	                url: Suncode.context( 'pzmodule' ).pluginContextPath + '/api/administration/partialattachment/template',
	                timeout: 600,
	                failure: function( form, action ) {
	                    Ext.Msg.show( {
	                        title: messages( 'pzmodule.error' ),
	                        msg: messages( 'pzmodule.templategenerationerror' ),
	                        buttons: Ext.Msg.OK,
	                        icon: 'dvnt-icon-x-circle dvnt-red-icon'
	                    } );
	                }
	            } );
        	}
        },
        closeWindow: function( button, e, eOpts ) {
            var win = button.up( 'window' );

            if ( !Ext.isEmpty( win ) ) {
            	win.close();
            }
        }
    } );
}( this.Ext4 ) );