/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.web.support.dto.document.builder;

import com.suncode.plugin.pzmodule.api.dto.document.DocumentDto;
import com.suncode.plugin.pzmodule.web.support.dto.document.builder.DocumentDtoBuilder;
import com.suncode.pwfl.archive.WfFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class DocumentDtoBuilderImpl
implements DocumentDtoBuilder {
    private static final Logger LOG = Logger.getLogger(DocumentDtoBuilderImpl.class);

    @Override
    public List<DocumentDto> build(List<WfFile> entities, String processId, String activityId) {
        ArrayList<DocumentDto> dtos = new ArrayList<DocumentDto>();
        if (CollectionUtils.isNotEmpty(entities)) {
            for (WfFile entity : entities) {
                dtos.add(this.build(entity, processId, activityId));
            }
        }
        return dtos;
    }

    @Override
    public DocumentDto build(WfFile entity, String processId, String activityId) {
        DocumentDto dto = new DocumentDto();
        dto.setName(entity.getFileName());
        dto.setPreviewLink(this.buildPreviewLink(entity, processId, activityId));
        dto.setShowFileLink(this.buildShowFileLink(entity));
        return dto;
    }

    private String buildPreviewLink(WfFile entity, String processId, String activityId) {
        StringBuilder link = new StringBuilder();
        link.append("com.plusmpm.servlet.ShowFileServlet.customServlet?fileId=");
        link.append(entity.getId());
        link.append("&processId=");
        link.append(processId);
        link.append("&activityId=");
        link.append(activityId);
        return link.toString();
    }

    private String buildShowFileLink(WfFile entity) {
        StringBuilder link = new StringBuilder();
        link.append("ShowFile.do?fileName=");
        link.append(this.encodeFileId(entity.getId()));
        return link.toString();
    }

    private String encodeFileId(Long fileId) {
        try {
            String stringFileId = String.valueOf(fileId);
            byte[] bytes = stringFileId.getBytes("UTF8");
            return new String(new Base64().encode(bytes), "UTF8");
        }
        catch (UnsupportedEncodingException exception) {
            LOG.error((Object)exception.getMessage(), (Throwable)exception);
            return "";
        }
    }
}

