/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.web.support.dto.configuration.builder;

import com.suncode.plugin.pzmodule.api.dto.configuration.DocumentFilterDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.PanelsConfigurationDto;
import com.suncode.plugin.pzmodule.api.enumeration.FiltersType;
import com.suncode.plugin.pzmodule.model.configuration.PanelsConfiguration;
import com.suncode.plugin.pzmodule.translation.Translator;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.DocumentFilterDtoBuilder;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.PanelsConfigurationDtoBuilder;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PanelsConfigurationDtoBuilderImpl
implements PanelsConfigurationDtoBuilder {
    private static final String DEFAULT_ATTACH_BUTTON_TEXT = "pzmodule.program.panel.button.attach";
    private static final String DEFAULT_DETACH_BUTTON_TEXT = "pzmodule.program.panel.button.detach";
    private static final String DEFAULT_DETACH_ALL_BUTTON_TEXT = "pzmodule.program.panel.button.detachall";
    private static final String DEFAULT_SAVE_BUTTON_TEXT = "pzmodule.program.panel.button.save";
    private static final String DEFAULT_CLOSE_BUTTON_TEXT = "pzmodule.program.panel.button.close";
    @Autowired
    private DocumentFilterDtoBuilder documentFilterDtoBuilder;
    @Autowired
    private Translator translator;

    @Override
    public PanelsConfigurationDto build(PanelsConfiguration entity) {
        PanelsConfigurationDto dto = new PanelsConfigurationDto();
        if (entity != null) {
            dto.setNotAttachedPageSize(entity.getNotAttachedPageSize());
            dto.setNotAttachedPagingDisabled(entity.getNotAttachedPagingDisabled());
            dto.setNotAttachedTitle(entity.getNotAttachedTitle());
            dto.setNotAttachedFiltersType(this.buildNotAttachedFiltersType(entity));
            dto.setAttachedTitle(entity.getAttachedTitle());
            dto.setRightVisible(entity.getRightVisible());
            dto.setRightTitle(entity.getRightTitle());
            dto.setAttachButtonText(this.buildAttachButtonText(entity));
            dto.setDetachButtonText(this.buildDetachButtonText(entity));
            dto.setDetachAllButtonText(this.buildDetachAllButtonText(entity));
            dto.setSaveButtonText(this.buildSaveButtonText(entity));
            dto.setCloseButtonText(this.buildCloseButtonText(entity));
            dto.setSelectionButtonsInMenu(BooleanUtils.isTrue((Boolean)entity.getSelectionButtonsInMenu()));
            dto.setToggleGroupsButtonEnabled(BooleanUtils.isTrue((Boolean)entity.getToggleGroupsButtonEnabled()));
            dto.setDocumentFilters(this.buildDocumentFilters(entity));
        } else {
            dto.setNotAttachedFiltersType(FiltersType.PANEL.getName());
        }
        return dto;
    }

    private String buildNotAttachedFiltersType(PanelsConfiguration entity) {
        return this.buildFiltersType(entity.getNotAttachedFiltersType());
    }

    private String buildFiltersType(String name) {
        return FiltersType.getByName(name).getName();
    }

    private String buildAttachButtonText(PanelsConfiguration entity) {
        return this.buildButtonText(entity.getAttachButtonText(), DEFAULT_ATTACH_BUTTON_TEXT);
    }

    private String buildDetachButtonText(PanelsConfiguration entity) {
        return this.buildButtonText(entity.getDetachButtonText(), DEFAULT_DETACH_BUTTON_TEXT);
    }

    private String buildDetachAllButtonText(PanelsConfiguration entity) {
        return this.buildButtonText(entity.getDetachAllButtonText(), DEFAULT_DETACH_ALL_BUTTON_TEXT);
    }

    private String buildSaveButtonText(PanelsConfiguration entity) {
        return this.buildButtonText(entity.getSaveButtonText(), DEFAULT_SAVE_BUTTON_TEXT);
    }

    private String buildCloseButtonText(PanelsConfiguration entity) {
        return this.buildButtonText(entity.getCloseButtonText(), DEFAULT_CLOSE_BUTTON_TEXT);
    }

    private String buildButtonText(String text, String defaultText) {
        return (String)StringUtils.defaultIfBlank((CharSequence)text, (CharSequence)this.buildDefaultButtonText(defaultText));
    }

    private String buildDefaultButtonText(String defaultText) {
        return this.translator.translateMessage(defaultText);
    }

    private List<DocumentFilterDto> buildDocumentFilters(PanelsConfiguration entity) {
        return this.documentFilterDtoBuilder.build(entity.getDocumentFilters());
    }
}

