/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.web.support.dto.configuration.builder;

import com.suncode.plugin.pzmodule.api.dto.configuration.GroupSumDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.GrouperDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.GroupingConfigurationDto;
import com.suncode.plugin.pzmodule.model.configuration.GroupSum;
import com.suncode.plugin.pzmodule.model.configuration.Grouper;
import com.suncode.plugin.pzmodule.model.configuration.GroupingConfiguration;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.GroupSumDtoBuilder;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.GrouperDtoBuilder;
import com.suncode.plugin.pzmodule.web.support.dto.configuration.builder.GroupingConfigurationDtoBuilder;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GroupingConfigurationDtoBuilderImpl
implements GroupingConfigurationDtoBuilder {
    @Autowired
    private GrouperDtoBuilder grouperDtoBuilder;
    @Autowired
    private GroupSumDtoBuilder groupSumDtoBuilder;

    @Override
    public GroupingConfigurationDto build(GroupingConfiguration entity) {
        GroupingConfigurationDto dto = new GroupingConfigurationDto();
        if (entity != null) {
            dto.setAttachedStartCollapsed(entity.getAttachedStartCollapsed());
            dto.setAttachedMenuEnabled(entity.getAttachedMenuEnabled());
            dto.setNotAttachedStartCollapsed(entity.getNotAttachedStartCollapsed());
            dto.setNotAttachedMenuEnabled(entity.getNotAttachedMenuEnabled());
            dto.setAttachedGroupers(this.buildAttachedGroupers(entity));
            dto.setNotAttachedGroupers(this.buildNotAttachedGroupers(entity));
            dto.setAttachedGroupSums(this.buildAttachedGroupSums(entity));
            dto.setNotAttachedGroupSums(this.buildNotAttachedGroupSums(entity));
        }
        return dto;
    }

    private List<GrouperDto> buildAttachedGroupers(GroupingConfiguration entity) {
        return this.buildGroupers(entity.getAttachedGroupers());
    }

    private List<GrouperDto> buildNotAttachedGroupers(GroupingConfiguration entity) {
        return this.buildGroupers(entity.getNotAttachedGroupers());
    }

    private List<GrouperDto> buildGroupers(List<Grouper> entities) {
        return this.grouperDtoBuilder.build(entities);
    }

    private List<GroupSumDto> buildAttachedGroupSums(GroupingConfiguration entity) {
        return this.buildGroupSums(entity.getAttachedGroupSums());
    }

    private List<GroupSumDto> buildNotAttachedGroupSums(GroupingConfiguration entity) {
        return this.buildGroupSums(entity.getNotAttachedGroupSums());
    }

    private List<GroupSumDto> buildGroupSums(List<GroupSum> entities) {
        return this.groupSumDtoBuilder.build(entities);
    }
}

