/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.service.shark;

import com.plusmpm.util.ParseUtils;
import com.plusmpm.util.SharkFunctions;
import com.suncode.plugin.pzmodule.exception.SetProcessContextException;
import com.suncode.plugin.pzmodule.service.shark.SharkService;
import java.util.Map;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfmodel.InvalidData;
import org.enhydra.shark.api.client.wfmodel.UpdateNotAllowed;
import org.enhydra.shark.api.client.wfmodel.WfActivity;
import org.enhydra.shark.api.client.wfmodel.WfProcess;
import org.enhydra.shark.api.client.wfservice.ConnectFailed;
import org.enhydra.shark.api.client.wfservice.NotConnected;
import org.springframework.stereotype.Service;

@Service
public class SharkServiceImpl
implements SharkService {
    @Override
    public Map<String, Object> getProcessContext(SharkTransaction sharkTransaction, String processId) throws BaseException, ConnectFailed, NotConnected {
        WfProcess wfProcess = this.getWfProcess(sharkTransaction, processId);
        return wfProcess.process_context(sharkTransaction);
    }

    @Override
    public Map<String, Object> getActivityContext(SharkTransaction sharkTransaction, String processId, String activityId) throws BaseException, ConnectFailed, NotConnected {
        WfActivity wfActivity = SharkFunctions.getWfActivity((SharkTransaction)sharkTransaction, (String)processId, (String)activityId);
        return wfActivity.process_context(sharkTransaction);
    }

    @Override
    public Map<String, Object> putValueToContext(Map<String, Object> context, String id, String value) {
        Object newValue = ParseUtils.SetObjectValue((Object)context.get(id), (String)value);
        context.put(id, newValue);
        return context;
    }

    @Override
    public void setProcessContext(SharkTransaction sharkTransaction, String processId, Map<String, Object> context) throws BaseException, ConnectFailed, NotConnected, SetProcessContextException {
        WfProcess wfProcess = this.getWfProcess(sharkTransaction, processId);
        boolean success = SharkFunctions.SetProcessContext((SharkTransaction)sharkTransaction, (WfProcess)wfProcess, context);
        if (!success) {
            throw new SetProcessContextException();
        }
    }

    @Override
    public void setActivityContext(SharkTransaction sharkTransaction, String processId, String activityId, Map<String, Object> context) throws BaseException, InvalidData, UpdateNotAllowed, ConnectFailed, NotConnected {
        SharkFunctions.setActivityContext((SharkTransaction)sharkTransaction, (String)processId, (String)activityId, context);
    }

    private WfProcess getWfProcess(SharkTransaction sharkTransaction, String processId) throws BaseException, ConnectFailed, NotConnected {
        return SharkFunctions.getWfProcess((SharkTransaction)sharkTransaction, (String)processId);
    }
}

