/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.service.save;

import com.suncode.plugin.pzmodule.api.dto.configuration.ColumnDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.PartialAttachmentConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SaveActionDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SaveDto;
import com.suncode.plugin.pzmodule.api.enumeration.ColumnType;
import com.suncode.plugin.pzmodule.api.info.AttachedRecordsInfo;
import com.suncode.plugin.pzmodule.api.info.SaveInfo;
import com.suncode.plugin.pzmodule.api.record.Record;
import com.suncode.plugin.pzmodule.api.result.CustomSaveResult;
import com.suncode.plugin.pzmodule.api.saver.record.CustomRecordSaver;
import com.suncode.plugin.pzmodule.api.util.MathUtils;
import com.suncode.plugin.pzmodule.audit.AuditType;
import com.suncode.plugin.pzmodule.exception.SaveActionExecutorException;
import com.suncode.plugin.pzmodule.exception.SaveValidationException;
import com.suncode.plugin.pzmodule.executor.save.record.SaveActionExecutor;
import com.suncode.plugin.pzmodule.object.ValidationError;
import com.suncode.plugin.pzmodule.resolver.recordsaver.CustomRecordSaverResolver;
import com.suncode.plugin.pzmodule.resolver.recordsaver.SaveActionExecutorResolver;
import com.suncode.plugin.pzmodule.resolver.recordsaver.SaveActionResolver;
import com.suncode.plugin.pzmodule.service.configuration.AdministrationConfigurationService;
import com.suncode.plugin.pzmodule.service.save.SaveService;
import com.suncode.plugin.pzmodule.translation.Translator;
import com.suncode.plugin.pzmodule.validator.SaveValidator;
import com.suncode.plugin.pzmodule.web.rest.support.Result;
import com.suncode.plugin.pzmodule.web.rest.support.builder.ResultBuilder;
import com.suncode.pwfl.audit.builder.ManualAuditBuilder;
import com.suncode.pwfl.transaction.support.SharkTransactionCallback;
import com.suncode.pwfl.transaction.support.SharkTransactionCallbackWithoutResult;
import com.suncode.pwfl.transaction.support.SharkTransactionTemplate;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.api.SharkTransaction;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SaveServiceImpl
implements SaveService {
    private static final Logger LOG = Logger.getLogger(SaveServiceImpl.class);
    private static final String CONFIGURATION_NOT_FOUND_MESSAGE = "pzmodule.program.configuration.notfound";
    private static final String CONFIGURATION_ERROR_MESSAGE = "pzmodule.program.configuration.error";
    private static final String SAVE_ERROR_MESSAGE = "pzmodule.program.save.error";
    private static final String PARTIAL_ATTACHMENT_VALIDATION_FAILURE_MESSAGE = "pzmodule.program.validation.partialattachment.failure";
    private static final String USED_VALIDATION_FAILURE_MESSAGE = "pzmodule.program.validation.used.failure";
    @Autowired
    private AdministrationConfigurationService administrationConfigurationService;
    @Autowired
    @Qualifier(value="partialAttachmentAmountValidator")
    private SaveValidator partialAttachmentAmountValidator;
    @Autowired
    @Qualifier(value="usedValidator")
    private SaveValidator usedValidator;
    @Autowired
    private CustomRecordSaverResolver customRecordSaverResolver;
    @Autowired
    private SaveActionResolver saveActionResolver;
    @Autowired
    private SaveActionExecutorResolver saveActionExecutorResolver;
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    private ResultBuilder resultBuilder;
    @Autowired
    private Translator translator;

    @Override
    public Result save(String userId, String configurationId, SaveInfo saveInfo, AttachedRecordsInfo attachedRecordsInfo) {
        Date started = new Date();
        ConfigurationDto configuration = this.administrationConfigurationService.find(configurationId);
        if (configuration == null) {
            Result result = this.resultBuilder.buildError(this.buildConfigurationNotFoundMessage());
            this.logSaveAudit(userId, started, false, configurationId, saveInfo.getProcessId(), saveInfo.getActivityId());
            return result;
        }
        if (this.shouldValidatePartialAttachment(configuration, attachedRecordsInfo)) {
            return this.saveWithPartialAttachmentValidation(userId, configuration, saveInfo, attachedRecordsInfo, started);
        }
        if (this.shouldValidateUsed(configuration, attachedRecordsInfo)) {
            return this.saveWithUsedValidation(userId, configuration, saveInfo, attachedRecordsInfo, started);
        }
        return this.save(userId, configuration, saveInfo, attachedRecordsInfo, started);
    }

    private void logSaveAudit(String userId, Date started, boolean success, String configurationId, String processId, String activityId) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("pzmodule.program.audit.save.param.configurationid", configurationId);
        params.put("pzmodule.program.audit.save.param.processid", processId);
        params.put("pzmodule.program.audit.save.param.activityid", activityId);
        ManualAuditBuilder.getInstance().type(AuditType.AUDIT_SAVE.getValue()).username(userId).success(success).params(params).started(started).stopped(new Date()).build().log();
    }

    private boolean shouldValidatePartialAttachment(ConfigurationDto configuration, AttachedRecordsInfo attachedRecordsInfo) {
        PartialAttachmentConfigurationDto partialAttachmentConfiguration = configuration.getPartialAttachmentConfiguration();
        return CollectionUtils.isNotEmpty(attachedRecordsInfo.getAttachedRecords()) && StringUtils.isNotBlank((CharSequence)partialAttachmentConfiguration.getAmountColumnId()) && BooleanUtils.isTrue((Boolean)partialAttachmentConfiguration.getValidate());
    }

    private synchronized Result saveWithPartialAttachmentValidation(String userId, ConfigurationDto configuration, SaveInfo saveInfo, AttachedRecordsInfo attachedRecordsInfo, Date started) {
        List<ValidationError> errors = null;
        try {
            errors = this.partialAttachmentAmountValidator.validate(configuration, saveInfo, attachedRecordsInfo.getAttachedRecords());
        }
        catch (SaveValidationException exception) {
            Result result = this.resultBuilder.buildError(this.buildSaveErrorMessage());
            this.logSaveAudit(userId, started, false, configuration.getConfigurationId(), saveInfo.getProcessId(), saveInfo.getActivityId());
            return result;
        }
        if (CollectionUtils.isNotEmpty(errors)) {
            Result result = this.buildPartialAttachmentValidationFailureResult(errors);
            this.logSaveAudit(userId, started, false, configuration.getConfigurationId(), saveInfo.getProcessId(), saveInfo.getActivityId());
            return result;
        }
        return this.save(userId, configuration, saveInfo, attachedRecordsInfo, started);
    }

    private Result buildPartialAttachmentValidationFailureResult(List<ValidationError> errors) {
        return this.buildValidationFailureResult(this.buildPartialAttachmentValidationFailureMessage(), errors);
    }

    private Result buildValidationFailureResult(String message, List<ValidationError> errors) {
        Result result = this.resultBuilder.buildError(message, errors);
        result.setSaveValid(false);
        return result;
    }

    private boolean shouldValidateUsed(ConfigurationDto configuration, AttachedRecordsInfo attachedRecordsInfo) {
        return CollectionUtils.isNotEmpty(attachedRecordsInfo.getAttachedRecords()) && BooleanUtils.isNotTrue((Boolean)configuration.getEnableDuplicateChoice()) && StringUtils.isBlank((CharSequence)configuration.getPartialAttachmentConfiguration().getAmountColumnId());
    }

    private synchronized Result saveWithUsedValidation(String userId, ConfigurationDto configuration, SaveInfo saveInfo, AttachedRecordsInfo attachedRecordsInfo, Date started) {
        List<ValidationError> errors = null;
        try {
            errors = this.usedValidator.validate(configuration, saveInfo, attachedRecordsInfo.getAttachedRecords());
        }
        catch (SaveValidationException exception) {
            Result result = this.resultBuilder.buildError(this.buildSaveErrorMessage());
            this.logSaveAudit(userId, started, false, configuration.getConfigurationId(), saveInfo.getProcessId(), saveInfo.getActivityId());
            return result;
        }
        if (CollectionUtils.isNotEmpty(errors)) {
            Result result = this.buildUsedValidationFailureResult(errors);
            this.logSaveAudit(userId, started, false, configuration.getConfigurationId(), saveInfo.getProcessId(), saveInfo.getActivityId());
            return result;
        }
        return this.save(userId, configuration, saveInfo, attachedRecordsInfo, started);
    }

    private Result buildUsedValidationFailureResult(List<ValidationError> errors) {
        return this.buildValidationFailureResult(this.buildUsedValidationFailureMessage(), errors);
    }

    private Result save(String userId, final ConfigurationDto configuration, final SaveInfo saveInfo, final AttachedRecordsInfo attachedRecordsInfo, Date started) {
        try {
            SharkTransactionTemplate transactionTemplate = new SharkTransactionTemplate();
            transactionTemplate.execute((SharkTransactionCallback)new SharkTransactionCallbackWithoutResult(){

                public void doInSharkTransactionWithoutResult(SharkTransaction sharkTransaction, TransactionStatus status) throws Exception {
                    List<Record> attachedRecords = SaveServiceImpl.this.format(configuration, attachedRecordsInfo.getAttachedRecords());
                    SaveDto save = configuration.getSave();
                    String customClass = save.getCustomClass();
                    if (StringUtils.isNotBlank((CharSequence)customClass)) {
                        CustomRecordSaver saver = SaveServiceImpl.this.customRecordSaverResolver.resolove(customClass);
                        if (saver == null) {
                            throw new Exception(SaveServiceImpl.this.buildConfigurationErrorMessage());
                        }
                        CustomSaveResult result = saver.save(sharkTransaction, configuration, saveInfo, attachedRecords);
                        if (BooleanUtils.isFalse((Boolean)result.isSuccess())) {
                            throw new Exception(result.getErrorMessage());
                        }
                        if (BooleanUtils.isTrue((Boolean)result.isAttachedRecordsChanged())) {
                            attachedRecords = result.getAttachedRecords();
                        }
                    }
                    SaveServiceImpl.this.save(sharkTransaction, configuration, saveInfo, attachedRecords);
                }
            });
            Result result = this.resultBuilder.build();
            this.logSaveAudit(userId, started, true, configuration.getConfigurationId(), saveInfo.getProcessId(), saveInfo.getActivityId());
            return result;
        }
        catch (Exception exception) {
            Result result = this.resultBuilder.buildError(exception.getMessage());
            this.logSaveAudit(userId, started, false, configuration.getConfigurationId(), saveInfo.getProcessId(), saveInfo.getActivityId());
            return result;
        }
    }

    private List<Record> format(ConfigurationDto configuration, List<Record> attachedRecords) {
        Map<String, Integer> accuracies = this.getColumnAccuracies(configuration);
        if (MapUtils.isNotEmpty(accuracies) && CollectionUtils.isNotEmpty(attachedRecords)) {
            for (Record record : attachedRecords) {
                this.format(record, accuracies);
            }
        }
        return attachedRecords;
    }

    private Map<String, Integer> getColumnAccuracies(ConfigurationDto configuration) {
        HashMap<String, Integer> accuracies = new HashMap<String, Integer>();
        List<ColumnDto> columns = configuration.getAttachedColumns();
        if (CollectionUtils.isNotEmpty(columns)) {
            for (ColumnDto column : columns) {
                ColumnType columnType = ColumnType.getByName(column.getColumnType());
                if (!columnType.equals((Object)ColumnType.FLOAT)) continue;
                accuracies.put(column.getDataIndex(), column.getDecimalPrecision());
            }
        }
        return accuracies;
    }

    private void format(Record record, Map<String, Integer> accuracies) {
        for (String key : record.keySet()) {
            String value;
            if (!accuracies.containsKey(key) || !StringUtils.isNotBlank((CharSequence)(value = record.getValue(key)))) continue;
            int accuracy = accuracies.get(key);
            Double result = MathUtils.round(Double.valueOf(value), accuracy);
            record.setValue(key, result.toString());
        }
    }

    @Transactional
    private void save(SharkTransaction sharkTransaction, ConfigurationDto configuration, SaveInfo saveInfo, List<Record> attachedRecords) throws Exception {
        Session session = null;
        Transaction transaction = null;
        List<SaveActionDto> saveActions = this.saveActionResolver.resolve(configuration);
        if (CollectionUtils.isNotEmpty(saveActions)) {
            try {
                session = this.sessionFactory.openSession();
                transaction = session.beginTransaction();
                for (SaveActionDto saveAction : saveActions) {
                    SaveActionExecutor executor = this.saveActionExecutorResolver.resolve(saveAction);
                    if (executor == null) {
                        throw new Exception(this.buildConfigurationErrorMessage());
                    }
                    executor.execute(sharkTransaction, session, configuration, saveAction, saveInfo, attachedRecords);
                }
                transaction.commit();
            }
            catch (SaveActionExecutorException exception) {
                if (transaction != null && session.isOpen()) {
                    transaction.rollback();
                }
                throw new Exception(exception.getMessage());
            }
            catch (Exception exception) {
                LOG.error((Object)exception.getMessage(), (Throwable)exception);
                if (transaction != null && session.isOpen()) {
                    transaction.rollback();
                }
                throw exception;
            }
            finally {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
        }
    }

    private String buildConfigurationNotFoundMessage() {
        return this.translator.translateMessage(CONFIGURATION_NOT_FOUND_MESSAGE);
    }

    private String buildConfigurationErrorMessage() {
        return this.translator.translateMessage(CONFIGURATION_ERROR_MESSAGE);
    }

    private String buildSaveErrorMessage() {
        return this.translator.translateMessage(SAVE_ERROR_MESSAGE);
    }

    private String buildPartialAttachmentValidationFailureMessage() {
        return this.translator.translateMessage(PARTIAL_ATTACHMENT_VALIDATION_FAILURE_MESSAGE);
    }

    private String buildUsedValidationFailureMessage() {
        return this.translator.translateMessage(USED_VALIDATION_FAILURE_MESSAGE);
    }
}

