/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.validator;

import com.suncode.plugin.pzmodule.exception.SaveValidationException;
import com.suncode.plugin.pzmodule.object.Used;
import com.suncode.plugin.pzmodule.resolver.recordprovider.DataResultResolver;
import com.suncode.plugin.pzmodule.resolver.validator.UsedResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;
import org.hibernate.type.AbstractStandardBasicType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UsedResolverImpl
implements UsedResolver {
    private static final Logger LOG = Logger.getLogger(UsedResolverImpl.class);
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    private DataResultResolver dataResultResolver;

    @Override
    public List<Used> resolve(String validateUsedQuery, Map<String, AbstractStandardBasicType<?>> scalars) throws SaveValidationException {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.sessionFactory.openSession();
            transaction = session.beginTransaction();
            List<Used> data = this.getData(session, validateUsedQuery, scalars);
            transaction.commit();
            List<Used> list = data;
            return list;
        }
        catch (Exception exception) {
            LOG.error((Object)exception.getMessage(), (Throwable)exception);
            if (transaction != null && session.isOpen()) {
                transaction.rollback();
            }
            throw new SaveValidationException();
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    private List<Used> getData(Session session, String validateUsedQuery, Map<String, AbstractStandardBasicType<?>> scalars) {
        NativeQuery dataSqlQuery = session.createSQLQuery(validateUsedQuery);
        dataSqlQuery.setReadOnly(true);
        for (String scalarId : scalars.keySet()) {
            dataSqlQuery.addScalar(scalarId, (Type)scalars.get(scalarId));
        }
        List<Object[]> dataResult = this.dataResultResolver.resolve((SQLQuery)dataSqlQuery);
        return this.getData(dataResult);
    }

    private List<Used> getData(List<Object[]> dataResult) {
        ArrayList<Used> data = new ArrayList<Used>();
        if (CollectionUtils.isNotEmpty(dataResult)) {
            for (Object[] datumResult : dataResult) {
                data.add(this.getDatum(datumResult));
            }
        }
        return data;
    }

    private Used getDatum(Object[] datumResult) {
        Used datum = new Used();
        Object value = datumResult[0];
        String stringValue = "";
        if (value != null) {
            stringValue = value.toString();
        }
        datum.setPrimaryKeyValue(stringValue);
        return datum;
    }
}

