/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.resolver.validator;

import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.exception.SaveValidationException;
import com.suncode.plugin.pzmodule.object.RemainingAmount;
import com.suncode.plugin.pzmodule.resolver.recordprovider.DataResultResolver;
import com.suncode.plugin.pzmodule.resolver.validator.RemainingAmountResolver;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;
import org.hibernate.type.AbstractStandardBasicType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RemainingAmountResolverImpl
implements RemainingAmountResolver {
    private static final Logger LOG = Logger.getLogger(RemainingAmountResolverImpl.class);
    private static final String ZERO = "0";
    private static final int ROUND_PRECISION = 4;
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    private DataResultResolver dataResultResolver;

    @Override
    public List<RemainingAmount> resolve(ConfigurationDto configuration, String validateAmountsQuery, List<String> resultColumnIds, Map<String, AbstractStandardBasicType<?>> scalars) throws SaveValidationException {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.sessionFactory.openSession();
            transaction = session.beginTransaction();
            List<RemainingAmount> data = this.getData(configuration, session, validateAmountsQuery, resultColumnIds, scalars);
            transaction.commit();
            List<RemainingAmount> list = data;
            return list;
        }
        catch (Exception exception) {
            LOG.error((Object)exception.getMessage(), (Throwable)exception);
            if (transaction != null && session.isOpen()) {
                transaction.rollback();
            }
            throw new SaveValidationException();
        }
        finally {
            if (session != null && session.isOpen()) {
                session.close();
            }
        }
    }

    private List<RemainingAmount> getData(ConfigurationDto configuration, Session session, String validateAmountsQuery, List<String> resultColumnIds, Map<String, AbstractStandardBasicType<?>> scalars) {
        NativeQuery dataSqlQuery = session.createSQLQuery(validateAmountsQuery);
        dataSqlQuery.setReadOnly(true);
        for (String scalarId : scalars.keySet()) {
            dataSqlQuery.addScalar(scalarId, (Type)scalars.get(scalarId));
        }
        List<Object[]> dataResult = this.dataResultResolver.resolve((SQLQuery)dataSqlQuery);
        return this.getData(configuration, dataResult, resultColumnIds);
    }

    private List<RemainingAmount> getData(ConfigurationDto configuration, List<Object[]> dataResult, List<String> resultColumnIds) {
        ArrayList<RemainingAmount> data = new ArrayList<RemainingAmount>();
        if (CollectionUtils.isNotEmpty(dataResult)) {
            for (Object[] datumResult : dataResult) {
                data.add(this.getDatum(configuration, datumResult, resultColumnIds));
            }
        }
        return data;
    }

    private RemainingAmount getDatum(ConfigurationDto configuration, Object[] datumResult, List<String> resultColumnIds) {
        RemainingAmount datum = new RemainingAmount();
        String amountColumnId = configuration.getPartialAttachmentConfiguration().getAmountColumnId();
        for (int i = 0; i < resultColumnIds.size(); ++i) {
            String columnId = resultColumnIds.get(i);
            Object value = datumResult[i];
            if (StringUtils.equals((CharSequence)columnId, (CharSequence)"PZ_PARTIAL_AMOUNT")) {
                String stringAmount = (String)StringUtils.defaultIfBlank((CharSequence)value.toString(), (CharSequence)ZERO);
                datum.setAmount(RemainingAmountResolverImpl.parse(stringAmount));
                continue;
            }
            if (StringUtils.equals((CharSequence)columnId, (CharSequence)amountColumnId)) {
                String stringTotal = (String)StringUtils.defaultIfBlank((CharSequence)value.toString(), (CharSequence)ZERO);
                datum.setTotal(RemainingAmountResolverImpl.parse(stringTotal));
                continue;
            }
            String stringValue = "";
            if (value != null) {
                stringValue = value.toString();
            }
            datum.setPrimaryKeyValue(stringValue);
        }
        return datum;
    }

    private static double parse(String value) {
        BigDecimal bigDecimal = new BigDecimal(Double.valueOf(value));
        bigDecimal = bigDecimal.setScale(4, RoundingMode.HALF_UP);
        return bigDecimal.doubleValue();
    }
}

