/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.provider.record;

import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.exception.RecordProviderException;
import com.suncode.plugin.pzmodule.api.info.AttachedInfo;
import com.suncode.plugin.pzmodule.api.info.FilterInfo;
import com.suncode.plugin.pzmodule.api.info.PagingInfo;
import com.suncode.plugin.pzmodule.api.info.SearchInfo;
import com.suncode.plugin.pzmodule.api.info.SortInfo;
import com.suncode.plugin.pzmodule.api.provider.record.RecordProvider;
import com.suncode.plugin.pzmodule.api.record.RecordPage;
import com.suncode.plugin.pzmodule.api.result.GroupSumResult;
import com.suncode.plugin.pzmodule.api.result.SumAllResult;
import com.suncode.plugin.pzmodule.api.translation.ColumnTranslation;
import com.suncode.plugin.pzmodule.provider.record.InternalRecordProvider;
import com.suncode.plugin.pzmodule.resolver.configuration.ConfigurationResolver;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="databaseTableRecordProvider")
public class DatabaseTableRecordProviderImpl
implements RecordProvider {
    @Autowired
    private ConfigurationResolver configurationResolver;
    @Autowired
    private InternalRecordProvider internalRecordProvider;

    @Override
    public RecordPage getPage(ConfigurationDto configuration, boolean attached, AttachedInfo attachedInfo, SearchInfo searchInfo, FilterInfo filterInfo, SortInfo sortInfo, PagingInfo pagingInfo) throws RecordProviderException {
        ColumnTranslation columnTranslation = new ColumnTranslation();
        String tableName = this.configurationResolver.resolveSearchLocationName(configuration, attached);
        return this.internalRecordProvider.getPage(configuration, attached, attachedInfo, searchInfo, filterInfo, sortInfo, pagingInfo, tableName, columnTranslation);
    }

    @Override
    public List<GroupSumResult> sumInGroup(ConfigurationDto configuration, boolean attached, AttachedInfo attachedInfo, SearchInfo searchInfo, FilterInfo filterInfo) throws RecordProviderException {
        ColumnTranslation columnTranslation = new ColumnTranslation();
        String tableName = this.configurationResolver.resolveSearchLocationName(configuration, attached);
        return this.internalRecordProvider.sumInGroups(configuration, attached, attachedInfo, searchInfo, filterInfo, tableName, columnTranslation);
    }

    @Override
    public SumAllResult sumAll(ConfigurationDto configuration, boolean attached, String columnId, AttachedInfo attachedInfo, SearchInfo searchInfo, FilterInfo filterInfo) throws RecordProviderException {
        ColumnTranslation columnTranslation = new ColumnTranslation();
        String tableName = this.configurationResolver.resolveSearchLocationName(configuration, attached);
        return this.internalRecordProvider.sumAll(configuration, attached, columnId, attachedInfo, searchInfo, filterInfo, tableName, columnTranslation);
    }
}

