/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.executor.save.record;

import com.plusmpm.database.DocumentTemplateTable;
import com.plusmpm.util.PlusReportGenerator.ReportGenerator;
import com.plusmpm.util.documents.DocumentEventTypes;
import com.suncode.plugin.pzmodule.api.dto.configuration.ConfigurationDto;
import com.suncode.plugin.pzmodule.api.dto.configuration.SaveActionDto;
import com.suncode.plugin.pzmodule.api.info.SaveInfo;
import com.suncode.plugin.pzmodule.api.record.Record;
import com.suncode.plugin.pzmodule.comparator.RecordComparator;
import com.suncode.plugin.pzmodule.exception.SaveActionExecutorException;
import com.suncode.plugin.pzmodule.executor.save.record.SaveActionExecutor;
import com.suncode.plugin.pzmodule.resolver.recordprovider.DocumentClassResolver;
import com.suncode.plugin.pzmodule.resolver.recordsaver.DocumentTemplateResolver;
import com.suncode.plugin.pzmodule.resolver.recordsaver.SummaryDataSourceResolver;
import com.suncode.plugin.pzmodule.resolver.recordsaver.SummaryUserNameResolver;
import com.suncode.plugin.pzmodule.service.shark.SharkService;
import com.suncode.plugin.pzmodule.translation.Translator;
import com.suncode.pwfl.archive.DocumentClass;
import com.suncode.pwfl.archive.DocumentClassActionService;
import com.suncode.pwfl.archive.DocumentService;
import com.suncode.pwfl.archive.FileFinder;
import com.suncode.pwfl.archive.WfDocument;
import com.suncode.pwfl.archive.WfFile;
import com.suncode.pwfl.util.CoreServiceFactory;
import com.suncode.pwfl.util.FinderFactory;
import com.suncode.pwfl.util.ServiceFactory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.enhydra.shark.api.SharkTransaction;
import org.enhydra.shark.api.client.wfbase.BaseException;
import org.enhydra.shark.api.client.wfservice.ConnectFailed;
import org.enhydra.shark.api.client.wfservice.NotConnected;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="summarySaveActionExecutor")
public class SummarySaveActionExecutorImpl
implements SaveActionExecutor {
    private static final Logger LOG = Logger.getLogger(SummarySaveActionExecutorImpl.class);
    private static final String CONFIGURATION_ERROR_MESSAGE = "pzmodule.program.configuration.error";
    private static final String SAVE_ERROR_MESSAGE = "pzmodule.program.save.error";
    @Autowired
    private DocumentClassResolver documentClassResolver;
    @Autowired
    private DocumentTemplateResolver documentTemplateResolver;
    @Autowired
    private SharkService sharkService;
    @Autowired
    private SummaryUserNameResolver summaryUserNameResolver;
    @Autowired
    private SummaryDataSourceResolver summaryDataSourceResolver;
    @Autowired
    private Translator translator;

    @Override
    public void execute(SharkTransaction sharkTransaction, Session session, ConfigurationDto configuration, SaveActionDto saveAction, SaveInfo saveInfo, List<Record> attachedRecords) throws SaveActionExecutorException {
        DocumentClass documentClass = this.getSummaryDocumentClass(saveAction);
        if (documentClass == null) {
            LOG.error((Object)"Klasa dokumentow dla zestawienia nie istnieje");
            throw new SaveActionExecutorException(this.buildConfigurationErrorMessage());
        }
        DocumentTemplateTable documentTemplate = this.getSummaryDocumentTemplate(saveAction);
        if (documentTemplate == null) {
            LOG.error((Object)"Szablon dla zestawienia nie istnieje");
            throw new SaveActionExecutorException(this.buildConfigurationErrorMessage());
        }
        this.removeCurrentSummary(saveAction, saveInfo.getProcessId());
        if (CollectionUtils.isNotEmpty(attachedRecords)) {
            this.sortRecords(saveAction, attachedRecords);
            try {
                String primaryKeyName = configuration.getSearch().getLocation().getPrimaryKey().getName();
                this.execute(sharkTransaction, saveAction, saveInfo, attachedRecords, documentClass, documentTemplate, primaryKeyName);
            }
            catch (SaveActionExecutorException exception) {
                throw exception;
            }
            catch (Exception exception) {
                LOG.error((Object)exception.getMessage(), (Throwable)exception);
                throw new SaveActionExecutorException(this.buildSaveErrorMessage());
            }
        }
    }

    private DocumentClass getSummaryDocumentClass(SaveActionDto saveAction) {
        String documentClassName = saveAction.getDocumentClassName();
        return this.documentClassResolver.resolve(documentClassName);
    }

    private DocumentTemplateTable getSummaryDocumentTemplate(SaveActionDto saveAction) {
        String templateName = saveAction.getTemplateName();
        return this.documentTemplateResolver.resolve(templateName);
    }

    private void removeCurrentSummary(SaveActionDto saveAction, String processId) {
        List<WfFile> files = this.getProcessDocuments(processId);
        if (CollectionUtils.isNotEmpty(files)) {
            for (WfFile file : files) {
                DocumentClass documentClass = file.getDocumentClass();
                if (!StringUtils.equals((CharSequence)documentClass.getName(), (CharSequence)saveAction.getDocumentClassName())) continue;
                this.removeCurrentSummary(file);
            }
        }
    }

    private List<WfFile> getProcessDocuments(String processId) {
        FileFinder fileService = FinderFactory.getFileFinder();
        return fileService.getDocumentsFromProcess(processId, new String[]{"documentClass"});
    }

    private void removeCurrentSummary(WfFile file) {
        DocumentService documentService = ServiceFactory.getDocumentService();
        WfDocument document = documentService.getDocument(Long.valueOf(file.getId()));
        documentService.deleteDocument(document);
        DocumentClassActionService documentClassActionService = CoreServiceFactory.getDocumentClassActionService();
        documentClassActionService.executeArchiveActions(document, DocumentEventTypes.DELETE_DOCUMENT_FROM_ARCHIVE);
    }

    private void sortRecords(SaveActionDto saveAction, List<Record> attachedRecords) {
        if (StringUtils.isNotBlank((CharSequence)saveAction.getSortOrder())) {
            String[] columns = saveAction.getSortOrder().split(";");
            RecordComparator comparator = new RecordComparator(columns);
            Collections.sort(attachedRecords, comparator);
        }
    }

    private void execute(SharkTransaction sharkTransaction, SaveActionDto saveAction, SaveInfo saveInfo, List<Record> attachedRecords, DocumentClass documentClass, DocumentTemplateTable documentTemplate, String primaryKeyName) throws Exception {
        String processId = saveInfo.getProcessId();
        String activityId = saveInfo.getActivityId();
        Map<String, Object> processContext = this.getProcessContext(sharkTransaction, processId);
        Map<String, Object> activityContext = this.getActivityContext(sharkTransaction, processId, activityId);
        String summaryUserName = this.summaryUserNameResolver.resolve(sharkTransaction, saveAction, saveInfo, processContext);
        Map<String, Map<String, Object>> dataSource = this.summaryDataSourceResolver.resolve(saveAction, saveInfo, attachedRecords, activityContext, primaryKeyName);
        ReportGenerator reportGenerator = new ReportGenerator();
        reportGenerator.setAttachToProcess(true);
        reportGenerator.addFileFromXMLTemplate(sharkTransaction, processId, activityId, documentClass.getId(), documentTemplate.getId(), saveAction.getDescription(), dataSource, summaryUserName, BooleanUtils.isTrue((Boolean)saveAction.getHorizontalOrientation()));
    }

    private Map<String, Object> getProcessContext(SharkTransaction sharkTransaction, String processId) throws BaseException, ConnectFailed, NotConnected {
        return this.sharkService.getProcessContext(sharkTransaction, processId);
    }

    private Map<String, Object> getActivityContext(SharkTransaction sharkTransaction, String processId, String activityId) throws BaseException, ConnectFailed, NotConnected {
        return this.sharkService.getActivityContext(sharkTransaction, processId, activityId);
    }

    private String buildConfigurationErrorMessage() {
        return this.translator.translateMessage(CONFIGURATION_ERROR_MESSAGE);
    }

    private String buildSaveErrorMessage() {
        return this.translator.translateMessage(SAVE_ERROR_MESSAGE);
    }
}

