/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.evaluator;

import com.suncode.plugin.pzmodule.api.dto.configuration.SaveActionParameterDto;
import com.suncode.plugin.pzmodule.api.enumeration.SaveActionParameterOperation;
import com.suncode.plugin.pzmodule.api.enumeration.SaveActionParameterType;
import com.suncode.plugin.pzmodule.api.info.SaveInfo;
import com.suncode.plugin.pzmodule.api.record.Record;
import com.suncode.plugin.pzmodule.evaluator.SaveActionParameterEvaluator;
import com.suncode.plugin.pzmodule.exception.SaveActionExecutorException;
import com.suncode.plugin.pzmodule.translation.Translator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SaveActionParameterEvaluatorImpl
implements SaveActionParameterEvaluator {
    private static final Logger LOG = Logger.getLogger(SaveActionParameterEvaluatorImpl.class);
    private static final String CONFIGURATION_ERROR_MESSAGE = "pzmodule.program.configuration.error";
    @Autowired
    private Translator translator;

    @Override
    public String evaluate(SaveActionParameterDto saveActionParameter, SaveInfo saveInfo, Record record, List<Record> attachedRecords, Map<String, Object> activityContext, String primaryKeyName, String primaryKeyVariableId, boolean update) throws SaveActionExecutorException {
        SaveActionParameterType type = SaveActionParameterType.getByName(saveActionParameter.getType());
        if (type.equals((Object)SaveActionParameterType.UNKNOWN)) {
            LOG.error((Object)("Nieznany typ parametru akcji zapisu: " + saveActionParameter.getType()));
            throw new SaveActionExecutorException(this.buildConfigurationErrorMessage());
        }
        SaveActionParameterOperation operation = SaveActionParameterOperation.getByName(saveActionParameter.getOperation());
        if (operation.equals((Object)SaveActionParameterOperation.UNKNOWN)) {
            LOG.error((Object)("Nieznana operacja parametru akcji zapisu: " + saveActionParameter.getOperation()));
            throw new SaveActionExecutorException(this.buildConfigurationErrorMessage());
        }
        ArrayList<String> attachedPrimaryKeyValues = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(attachedRecords)) {
            for (Record attachedRecord : attachedRecords) {
                String primaryKeyValue = attachedRecord.getValue(primaryKeyName);
                attachedPrimaryKeyValues.add(primaryKeyValue);
            }
        }
        List<Record> detachedRecords = this.getDetachedRecords(saveInfo, attachedPrimaryKeyValues, primaryKeyName);
        return operation.calculate(saveActionParameter.getFromValue(), saveActionParameter.getToValue(), record, attachedRecords, detachedRecords, activityContext, type.getValueJoiner(), primaryKeyName, primaryKeyVariableId, type.isAccumulate(), update);
    }

    private String buildConfigurationErrorMessage() {
        return this.translator.translateMessage(CONFIGURATION_ERROR_MESSAGE);
    }

    private List<Record> getDetachedRecords(SaveInfo saveInfo, List<String> attachedPrimaryKeyValues, String primaryKeyName) {
        ArrayList<Record> records = new ArrayList<Record>();
        if (CollectionUtils.isNotEmpty(saveInfo.getInitiallyAttachedRecords())) {
            for (Record record : saveInfo.getInitiallyAttachedRecords()) {
                String primaryKeyValue = record.getValue(primaryKeyName);
                if (attachedPrimaryKeyValues.contains(primaryKeyValue)) continue;
                records.add(record);
            }
        }
        return records;
    }
}

