/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.api.enumeration;

import org.apache.commons.lang3.StringUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PrimaryKeyType {
    STRING("string"){

        @Override
        public String getConditionSuffix() {
            return "'";
        }
    }
    ,
    INT("int"){

        @Override
        public String getConditionSuffix() {
            return "";
        }
    }
    ,
    FLOAT("float"){

        @Override
        public String getConditionSuffix() {
            return "";
        }
    }
    ,
    DATE("date"){

        @Override
        public String getConditionSuffix() {
            return "'";
        }
    }
    ,
    DATE_STRING("datestring"){

        @Override
        public String getConditionSuffix() {
            return "'";
        }
    };

    private String name;

    private PrimaryKeyType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static PrimaryKeyType getByName(String name) {
        for (PrimaryKeyType primaryKeyType : PrimaryKeyType.values()) {
            if (!StringUtils.equals((CharSequence)name, (CharSequence)primaryKeyType.getName())) continue;
            return primaryKeyType;
        }
        return STRING;
    }

    public abstract String getConditionSuffix();
}

