/*
 * Decompiled with CFR 0.152.
 */
package com.suncode.plugin.pzmodule.api.enumeration;

import org.apache.commons.lang3.StringUtils;

public enum Operator {
    EQUAL("eq", "="),
    NOT_EQUAL("neq", "!="),
    LESS_THAN("lt", "<"),
    LESS_OR_EQUAL("lte", "<="),
    GREATER_THAN("gt", ">"),
    GREATER_OR_EQUAL("gte", ">=");

    private String name;
    private String sign;

    private Operator(String name, String sign) {
        this.name = name;
        this.sign = sign;
    }

    public String getName() {
        return this.name;
    }

    public String getSign() {
        return this.sign;
    }

    public static Operator getByName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return EQUAL;
        }
        for (Operator operator : Operator.values()) {
            if (!StringUtils.equals((CharSequence)name, (CharSequence)operator.getName())) continue;
            return operator;
        }
        return EQUAL;
    }
}

