( function( Ext ) {
    var messages = Suncode.context( 'pzmodule' ).messages;

    Ext.define( 'Suncode.pzmodule.view.window.SettingsWindow', {
        id: 'settingswindow',
        extend: 'Ext.window.Window',
        alias: 'widget.settingswindow',
        requires: [ 'Suncode.pzmodule.view.table.SettingsTable' ],
        title: messages( 'pzmodule.settings' ),
        modal: true,
        initComponent: function() {
        	this.items = [ {
                xtype: 'form',
                frame: false,
                border: 0,
                buttonAlign: 'center',
                items: [ Ext.create( 'Suncode.pzmodule.view.table.SettingsTable', {
            		width: 750,
            		height: 200,
            		table: this.table
            	} ) ],
                buttons: [ {
                    xtype: 'button',
                    itemId: 'loadSettingsButton',
                    text: messages( 'pzmodule.load' ),
                    iconCls: 'dvnt-icon-right'
                },{
                    xtype: 'button',
                    itemId: 'setAsDefaultButton',
                    text: messages( 'pzmodule.setasdefault' ),
                    iconCls: 'dvnt-icon-check-symbol'
                }, {
                    xtype: 'button',
                    itemId: 'deleteSettingsButton',
                    text: messages( 'pzmodule.delete' ),
                    iconCls: 'dvnt-icon-delete'
                }, {
                    xtype: 'button',
                    itemId: 'cancelButton',
                    text: messages( 'pzmodule.cancel' ),
                    iconCls: 'dvnt-icon-x-symbol'
                } ]
            } ];
    
            this.callParent( arguments );
        }
    } );
}( this.Ext4 ) );