(function (Ext) {
  Ext.define('Suncode.pzmodule.view.filter.PanelFilter', {
    extend: 'Ext.container.Container',
    border: false,
    width: '100%',
    layout: 'form',
    cls: 'pzmodule-panel-filter',
    initComponent: function () {
      this.callParent(arguments);
    },
    onFilterKeyDown: function (field, e, eOpts) {
      var key = e.getKey();

      if (key == e.ENTER) {
        e.stopEvent();
        this.onFilterKeyPress(field, e, eOpts);
      } else if (key == e.BACKSPACE || key == e.DELETE) {
        this.onFilterKeyPress(field, e, eOpts);
      }
    },
    onFilterKeyPress: function (field, e, eOpts) {
      var liveFiltering = this.liveFiltering;
      var key = e.getKey();

      if (field.isValid()) {
        if (liveFiltering && (!e.isSpecialKey() || key == e.ENTER || key
            == e.BACKSPACE || key == e.DELETE)) {
          this.runFilterTask(500);
        } else if (!liveFiltering && key == e.ENTER) {
          this.runFilterTask(0);
        }
      }
    },
    runFilterTask: function (delay) {
      this.filterTask.delay(delay);
    },
    getFilterValue: function () {
      var value = new Array();

      this.items.each(function (item, index, length) {
        var itemValue = item.getValue();

        if (!Ext.isEmpty(itemValue)) {
          value.push({
            type: this.filterType,
            field: this.filterField,
            comparison: item.comparison,
            value: itemValue
          });
        }
      }, this);

      return value;
    },
    onFilterAfterRender: function (filter, eOpts) {
      this.items.each(function (item, index, length) {
        item.inputEl.addListener('click', this.onFilterItemClick, this, {
          item: item
        });
      }, this);
    },
    onFilterItemClick: function (e, t, eOpts) {
      var item = eOpts.item;
      item.focus();
    },
    clearFilter: function () {
      this.items.each(function (item, index, length) {
        item.setValue('');
      }, this);
    }
  });
}(this.Ext4));